/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.yaml.snakeyaml_1_28.nodes;

import com.ibm.cognos.externals.org.yaml.snakeyaml_1_28.comments.CommentLine;
import com.ibm.cognos.externals.org.yaml.snakeyaml_1_28.error.Mark;
import com.ibm.cognos.externals.org.yaml.snakeyaml_1_28.nodes.NodeId;
import com.ibm.cognos.externals.org.yaml.snakeyaml_1_28.nodes.Tag;
import java.util.List;

public abstract class Node {
    private Tag tag;
    private Mark startMark;
    protected Mark endMark;
    private Class<? extends Object> type;
    private boolean twoStepsConstruction;
    private String anchor;
    private List<CommentLine> inLineComments;
    private List<CommentLine> blockComments;
    private List<CommentLine> endComments;
    protected boolean resolved;
    protected Boolean useClassConstructor;

    public Node(Tag tag, Mark mark, Mark mark2) {
        this.setTag(tag);
        this.startMark = mark;
        this.endMark = mark2;
        this.type = Object.class;
        this.twoStepsConstruction = false;
        this.resolved = true;
        this.useClassConstructor = null;
        this.inLineComments = null;
        this.blockComments = null;
        this.endComments = null;
    }

    public Tag getTag() {
        return this.tag;
    }

    public Mark getEndMark() {
        return this.endMark;
    }

    public abstract NodeId getNodeId();

    public Mark getStartMark() {
        return this.startMark;
    }

    public void setTag(Tag tag) {
        if (tag == null) {
            throw new NullPointerException("tag in a Node is required.");
        }
        this.tag = tag;
    }

    public final boolean equals(Object object) {
        return super.equals(object);
    }

    public Class<? extends Object> getType() {
        return this.type;
    }

    public void setType(Class<? extends Object> clazz) {
        if (!clazz.isAssignableFrom(this.type)) {
            this.type = clazz;
        }
    }

    public void setTwoStepsConstruction(boolean bl2) {
        this.twoStepsConstruction = bl2;
    }

    public boolean isTwoStepsConstruction() {
        return this.twoStepsConstruction;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public boolean useClassConstructor() {
        if (this.useClassConstructor == null) {
            if (!this.tag.isSecondary() && this.resolved && !Object.class.equals(this.type) && !this.tag.equals(Tag.NULL)) {
                return true;
            }
            return this.tag.isCompatible(this.getType());
        }
        return this.useClassConstructor;
    }

    public void setUseClassConstructor(Boolean bl2) {
        this.useClassConstructor = bl2;
    }

    @Deprecated
    public boolean isResolved() {
        return this.resolved;
    }

    public String getAnchor() {
        return this.anchor;
    }

    public void setAnchor(String string) {
        this.anchor = string;
    }

    public List<CommentLine> getInLineComments() {
        return this.inLineComments;
    }

    public void setInLineComments(List<CommentLine> list) {
        this.inLineComments = list;
    }

    public List<CommentLine> getBlockComments() {
        return this.blockComments;
    }

    public void setBlockComments(List<CommentLine> list) {
        this.blockComments = list;
    }

    public List<CommentLine> getEndComments() {
        return this.endComments;
    }

    public void setEndComments(List<CommentLine> list) {
        this.endComments = list;
    }
}

