/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.phoenix.api.core;

import com.ibm.cognos.autorestphoenix.api.core.ab;
import com.ibm.cognos.autorestphoenix.api.core.ao;
import com.ibm.cognos.autorestphoenix.api.core.ap;
import com.ibm.cognos.autorestphoenix.api.e;
import com.ibm.cognos.autorestphoenix.sql.ae;
import com.ibm.cognos.autorestphoenix.sql.bv;
import com.ibm.cognos.autorestphoenix.sql.k;
import com.ibm.cognos.autorestphoenix.sql.result.Result;
import com.ibm.cognos.autorestphoenix.sql.rowio.j;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JniCommunicator {
    static String footprint = "$Revision$";
    private final e mO;
    private byte[] mP = new byte[4096];
    private final ab fR;
    private static final byte[] mQ = new byte[37];
    private static final int mR = 5;
    private final GregorianCalendar mS = new GregorianCalendar();
    private bv mT;
    private static final String[] mU;
    static final int mV = 0;
    static final int mW = 1;
    private static final int mX = 17;
    static char[] mY;

    public JniCommunicator(String string, String string2) {
        bv.ah(string2, string);
        String string3 = bv.gi(string);
        String string4 = "datadirect.cloud.drivercommunication." + string3;
        Logger logger = Logger.getLogger(string4);
        this.fR = new ab(logger);
        this.mO = new e(null, this.fR);
        this.loadLegacyDrivers();
    }

    private void loadLegacyDrivers() {
        for (String string : mU) {
            try {
                Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (ClassLoader.getSystemResource(string.replace('.', '/') + ".class") == null && string.equals(classNotFoundException.getMessage())) continue;
                this.complain(string, classNotFoundException);
            }
            catch (Throwable throwable) {
                this.complain(string, throwable);
            }
        }
    }

    private void complain(String string, Throwable throwable) {
        this.fR.eu().j("class", string).a(throwable, true).a(Level.WARNING, "JniCommunicator.ctor");
    }

    public byte[] loadDriver(String string) {
        int n2 = 1;
        StringBuilder stringBuilder = new StringBuilder("loadDriver");
        stringBuilder.append("\r\n");
        stringBuilder.append("packaged name: ");
        stringBuilder.append(string);
        stringBuilder.append("\r\n");
        stringBuilder.append("status: ");
        this.fR.eu().j("class", string);
        try {
            Class.forName(string);
            stringBuilder.append("success");
            this.fR.j("status", "success").a(Level.CONFIG, "JniCommunicator.jniLoadDriver");
        }
        catch (Exception exception) {
            n2 = 0;
            String string2 = exception.getMessage();
            stringBuilder.append(string2);
            this.fR.j("status", "fail").a(exception, true).a(Level.SEVERE, "JniCommunicator.jniLoadDriver");
        }
        return this.serializeLoadDriverResponse(n2, stringBuilder.toString());
    }

    private byte[] serializeLoadDriverResponse(int n2, String string) {
        byte[] byArray = new byte[16];
        try (j j2 = new j(byArray);){
            j2.writeByte(n2);
            j2.iv(string);
            byArray = j2.JW();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byArray;
    }

    public byte[] execute(byte[] byArray) {
        Object object;
        if (byArray == null || byArray.length <= 0) {
            return this.abort("Invalid request buffer");
        }
        if (this.fR.eC()) {
            this.logBytes(byArray, true);
        }
        if (byArray.length < 5) {
            return this.abort("Invalid request buffer length");
        }
        int n2 = JniCommunicator.extractInt(byArray, 1);
        if (n2 < 5 || n2 > byArray.length) {
            return this.abort("Invalid request message length");
        }
        if (this.fR.eC() && n2 < byArray.length) {
            object = "buffer length (" + byArray.length + ") is greater than message length (" + n2 + ")";
            this.fR.ag((String)object).a(Level.CONFIG, "JniCommunicator.inputBytes");
        }
        try {
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, 0, n2);
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                int n3 = dataInputStream.read();
                if (n3 == 0 && byArray.length > 20) {
                    this.checkForOldConnect(byArray);
                }
                ao ao2 = new ao(byArray, 1, n2 - 1, this.mS);
                if (n3 == 31) {
                    Result result = Result.a(null, null, n3, dataInputStream, ao2, true);
                    object = this.connect(result);
                } else {
                    Result result = Result.a(this.mT, null, n3, dataInputStream, ao2, true);
                    object = this.mT.a(result);
                }
                ap ap2 = new ap(this.mP, (Calendar)this.mS);
                ((Result)object).a(ap2, false);
                this.mP = ap2.JW();
            }
            catch (Throwable throwable) {
                object = Result.b(throwable);
                ap ap3 = new ap(this.mP, (Calendar)this.mS);
                ((Result)object).a(ap3, false);
                this.mP = ap3.JW();
            }
        }
        catch (Throwable throwable) {
            return this.abort(throwable.getMessage());
        }
        if (this.fR.eC()) {
            this.logBytes(this.mP, false);
            this.logMemoryUsage("JNI after");
        }
        return this.mP;
    }

    private void checkForOldConnect(byte[] byArray) {
        int n2;
        int n3;
        int n4 = JniCommunicator.extractInt(byArray, 0);
        if (n4 > 20 && (n3 = JniCommunicator.extractInt(byArray, 4)) == 17 && (n2 = JniCommunicator.extractInt(byArray, 16)) != 14) {
            throw e.g(14, n2);
        }
    }

    private byte[] abort(String string) {
        this.fR.ag("ProtocolError").j("message", string).a(Level.CONFIG, "JniCommunicator.abort");
        if (this.fR.eC()) {
            this.logBytes(mQ, false);
        }
        return mQ;
    }

    private Result connect(Result result) throws ae {
        Result result2;
        if (this.fR.eB()) {
            this.fR.eu().j("TimeZone", this.mS.getTimeZone().toString()).a(Level.FINER, "JniCommunicator.connect");
        }
        if (!(result2 = bv.a(this.fR, this.mO, result)).FI()) {
            this.mT = k.b(result2.PI(), result2.PH());
            this.mT.Ee();
        }
        return result2;
    }

    public static int extractInt(byte[] byArray, int n2) {
        int n3 = byArray[n2++] & 0xFF;
        int n4 = byArray[n2++] & 0xFF;
        int n5 = byArray[n2++] & 0xFF;
        int n6 = byArray[n2] & 0xFF;
        return (n3 << 24) + (n4 << 16) + (n5 << 8) + n6;
    }

    void logBytes(byte[] byArray, boolean bl2) {
        StringBuilder stringBuilder;
        block8: {
            int n2;
            stringBuilder = new StringBuilder();
            byte by2 = byArray[0];
            int n3 = JniCommunicator.extractInt(byArray, 1);
            int n4 = Integer.MAX_VALUE;
            int n5 = Integer.MAX_VALUE;
            if (by2 == 0 && n3 > 20) {
                n3 = 20;
            }
            if (by2 == 31) {
                n2 = 9;
                n4 = n2 + 4;
                n5 = n4 + JniCommunicator.extractInt(byArray, n2);
            }
            n2 = 0;
            String string = Result.hP(by2);
            stringBuilder.append(string);
            stringBuilder.append(" ");
            stringBuilder.append(bl2 ? " request: " : " reply: ");
            stringBuilder.append(n3);
            stringBuilder.append(" bytes\r\n");
            do {
                byte by3;
                int n6;
                for (n6 = n2; n6 < n2 + 32; ++n6) {
                    if (n6 < n3) {
                        by3 = n6 >= n4 && n6 < n5 ? (byte)-52 : byArray[n6];
                        stringBuilder.append(JniCommunicator.byteToHex(by3));
                    } else {
                        stringBuilder.append("  ");
                    }
                    stringBuilder.append(' ');
                }
                stringBuilder.append("        ");
                for (n6 = n2; n6 < n2 + 32; ++n6) {
                    if (n6 < n3) {
                        by3 = n6 >= n4 && n6 < n5 ? (byte)42 : byArray[n6];
                        stringBuilder.append(JniCommunicator.byteToASCII(by3));
                        continue;
                    }
                    stringBuilder.append(' ');
                }
                stringBuilder.append("\r\n");
                if ((n2 += 32) <= n3) continue;
                stringBuilder.append("\r\n");
                break block8;
            } while (n2 < 1024);
            stringBuilder.append("(truncating output)\r\n");
        }
        this.fR.ag(stringBuilder.toString()).a(Level.CONFIG, "JniCommunicator.logBytes");
    }

    void logExtraBytes(byte[] byArray, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = byArray.length;
        int n4 = n2;
        n4 -= n2 % 32;
        stringBuilder.append("offset: " + n2);
        stringBuilder.append("  full length: " + n3 + "\r\n");
        do {
            byte by2;
            int n5;
            for (n5 = n4; n5 < n4 + 32; ++n5) {
                if (n5 >= n2 && n5 < n3) {
                    by2 = byArray[n5];
                    stringBuilder.append(JniCommunicator.byteToHex(by2));
                } else {
                    stringBuilder.append("  ");
                }
                stringBuilder.append(' ');
            }
            stringBuilder.append("        ");
            for (n5 = n4; n5 < n4 + 32; ++n5) {
                if (n5 >= n2 && n5 < n3) {
                    by2 = byArray[n5];
                    stringBuilder.append(JniCommunicator.byteToASCII(by2));
                    continue;
                }
                stringBuilder.append(' ');
            }
            stringBuilder.append("\r\n");
        } while ((n4 += 32) <= n3);
        stringBuilder.append("\r\n");
        this.fR.ag(stringBuilder.toString()).a(Level.CONFIG, "JniCommunicator.logExtraBytes");
    }

    static char[] byteToHex(byte by2) {
        char[] cArray = new char[]{mY[by2 >> 4 & 0xF], mY[by2 & 0xF]};
        return cArray;
    }

    static char byteToASCII(byte by2) {
        if (by2 > 31 && by2 < 127) {
            return (char)by2;
        }
        return '.';
    }

    private void logMemoryUsage(String string) {
        Runtime runtime = Runtime.getRuntime();
        long l2 = runtime.maxMemory();
        long l3 = runtime.totalMemory();
        long l4 = runtime.freeMemory();
        this.fR.ag("Memory Usage");
        this.fR.a("max", (Object)(l2 / 0x100000L));
        this.fR.a("total", (Object)(l3 / 0x100000L));
        this.fR.a("free", (Object)(l4 / 0x100000L));
        this.fR.a("inUse", (Object)((l3 - l4) / 0x100000L));
        this.fR.a(Level.FINE, string);
    }

    static {
        JniCommunicator.mQ[0] = 2;
        JniCommunicator.mQ[4] = 37;
        JniCommunicator.mQ[9] = 5;
        JniCommunicator.mQ[20] = 65;
        JniCommunicator.mQ[21] = 66;
        JniCommunicator.mQ[22] = 79;
        JniCommunicator.mQ[23] = 82;
        JniCommunicator.mQ[24] = 84;
        mU = new String[]{"com.ibm.cognos.jdbc.autorest.AutoRESTDriver", "com.ibm.cognos.jdbc.googlebigquery.GoogleBigQueryDriver", "com.ibm.cognos.jdbc.sforce.SForceDriver", "com.ibm.cognos.jdbc.snowflake.SnowflakeDriver"};
        mY = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }
}

