/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.phoenix.logging;

import com.ibm.cognos.phoenix.logging.DateFormatCache;
import com.ibm.cognos.phoenix.logging.ThreadNameMapper;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class OneLineFormatter
extends Formatter {
    private static final String LINE_SEP = System.getProperty("line.separator");
    private static final String ST_SEP = LINE_SEP + " ";
    private static final String timeFormat = "dd-MMM-yyyy HH:mm:ss";
    private static final int globalCacheSize = 30;
    private static final int localCacheSize = 5;
    private static final DateFormatCache globalDateCache = new DateFormatCache(30, "dd-MMM-yyyy HH:mm:ss", null);
    private static final ThreadLocal<DateFormatCache> localDateCache = new ThreadLocal<DateFormatCache>(){

        protected DateFormatCache a() {
            return new DateFormatCache(5, OneLineFormatter.timeFormat, globalDateCache);
        }

        @Override
        protected /* synthetic */ Object initialValue() {
            return this.a();
        }
    };

    @Override
    public String format(LogRecord logRecord) {
        StringBuilder stringBuilder = new StringBuilder();
        this.a(stringBuilder, logRecord.getMillis());
        stringBuilder.append(' ');
        stringBuilder.append(logRecord.getLevel());
        stringBuilder.append(' ');
        stringBuilder.append('[');
        String string = ThreadNameMapper.a(logRecord.getThreadID());
        if (string == null) {
            string = Thread.currentThread().getName();
        }
        stringBuilder.append(string);
        stringBuilder.append(']');
        stringBuilder.append(' ');
        stringBuilder.append(logRecord.getSourceClassName());
        stringBuilder.append('.');
        stringBuilder.append(logRecord.getSourceMethodName());
        stringBuilder.append(' ');
        stringBuilder.append(this.formatMessage(logRecord));
        if (logRecord.getThrown() != null) {
            stringBuilder.append(ST_SEP);
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            logRecord.getThrown().printStackTrace(printWriter);
            printWriter.close();
            stringBuilder.append(stringWriter.getBuffer());
        }
        stringBuilder.append(LINE_SEP);
        return stringBuilder.toString();
    }

    protected void a(StringBuilder stringBuilder, long l2) {
        stringBuilder.append(localDateCache.get().a(l2));
        long l3 = l2 % 1000L;
        stringBuilder.append('.');
        if (l3 < 100L) {
            stringBuilder.append('0');
            if (l3 < 10L) {
                stringBuilder.append('0');
            }
        }
        stringBuilder.append(l3);
    }
}

