/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.jdbc41.cognos.adaptor;

import com.ibm.cognos.jdbc.adaptor.AbstractAdaptor;
import com.ibm.cognos.jdbc.adaptor.AdaptorFactory;
import com.ibm.cognos.jdbc.adaptor.BaseDatabaseMetadataAdaptor;
import com.ibm.cognos.jdbc.adaptor.BaseResultSetAdaptor;
import com.ibm.cognos.jdbc.adaptor.IWrapper;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RedshiftDatabaseMetadataAdaptor
extends BaseDatabaseMetadataAdaptor {
    private static final String UNKNOWN = "unknown";
    private Pattern ptn = Pattern.compile("(.*?)((?i)redshift)(\\s+)((\\d+)\\.(\\d+)\\.(\\d+))(.*)");
    private int databaseMajor = 0;
    private int databaseMinor = 0;
    private int databaseSubminor = 0;
    private String productName = "unknown";

    public RedshiftDatabaseMetadataAdaptor(Object obj, AdaptorFactory factory) {
        super((DatabaseMetaData)obj, factory);
        this.getRedshiftVersion();
    }

    protected int getDatabaseMajorVersionImpl() throws SQLException {
        return this.databaseMajor;
    }

    protected int getDatabaseMinorVersionImpl() throws SQLException {
        return this.databaseMinor;
    }

    protected String getDatabaseProductNameImpl() throws SQLException {
        return this.productName;
    }

    protected String getDatabaseProductVersionImpl() throws SQLException {
        return String.format("%d.%d.%d", this.databaseMajor, this.databaseMinor, this.databaseSubminor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getRedshiftVersion() {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            Matcher versionInfo;
            stmt = super.getConnection().createStatement();
            stmt.execute("select version()");
            rs = stmt.getResultSet();
            String s = null;
            if (rs.next() && (versionInfo = this.ptn.matcher(s = rs.getString(1))).matches()) {
                this.productName = versionInfo.group(2);
                this.databaseMajor = Integer.parseInt(versionInfo.group(5));
                this.databaseMinor = Integer.parseInt(versionInfo.group(6));
                this.databaseSubminor = Integer.parseInt(versionInfo.group(7));
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    protected ResultSet getSchemasImpl() throws SQLException {
        return new RedshiftGetSchemasResultSetAdaptor(this.dmd.getSchemas(), this.factory, this.dmd.getConnection().getCatalog());
    }

    protected ResultSet getSchemasImpl(String catalog, String schemaPattern) throws SQLException {
        return new RedshiftGetSchemasResultSetAdaptor(this.dmd.getSchemas(catalog, schemaPattern), this.factory, this.dmd.getConnection().getCatalog());
    }

    public static class RedshiftGetSchemasResultSetAdaptor
    extends BaseResultSetAdaptor {
        String defaultCatalog;

        RedshiftGetSchemasResultSetAdaptor(ResultSet rs, AdaptorFactory f, String catalog) {
            super(rs, f);
            this.defaultCatalog = catalog;
        }

        public String getString(int colNo) throws SQLException {
            if (2 == colNo) {
                String catName = this.rs.getString(colNo);
                if (null == catName) {
                    try {
                        catName = super.getConnection().getCatalog();
                    }
                    catch (NullPointerException e) {
                        return this.defaultCatalog;
                    }
                }
                return catName;
            }
            return this.rs.getString(colNo);
        }

        public String getString(String colName) throws SQLException {
            if ("TABLE_CAT".equals(colName)) {
                String catName = this.rs.getString(colName);
                if (null == catName) {
                    try {
                        catName = super.getConnection().getCatalog();
                    }
                    catch (NullPointerException e) {
                        return this.defaultCatalog;
                    }
                }
                return catName;
            }
            return this.rs.getString(colName);
        }
    }

    public static final class Wrapper
    implements IWrapper {
        public AbstractAdaptor wrap(Object toWrap, AdaptorFactory factory) {
            return new RedshiftDatabaseMetadataAdaptor((DatabaseMetaData)toWrap, factory);
        }
    }
}

