/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryService;

public class ByteRange {
    private final long docSize;
    private long startPos;
    private long endPos;
    private boolean valid = true;
    private boolean forward = true;

    public ByteRange(String range, long docSize) {
        this.docSize = docSize;
        this.parse(range);
    }

    public ByteRange(String range) {
        this(range, -1L);
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public boolean isForward() {
        return this.forward;
    }

    public void setForward(boolean forward) {
        this.forward = forward;
    }

    public long getStartPos() {
        return this.startPos;
    }

    public void setStartPos(long startPos) {
        this.startPos = startPos;
    }

    public long getEndPos() {
        return this.endPos;
    }

    public void setEndPos(long endPos) {
        this.endPos = endPos;
    }

    private void parse(String range) {
        if (this.isValidRangeString(range)) {
            this.valid = false;
            return;
        }
        this.parsePositions(range);
        if (!this.valid) {
            return;
        }
        if (this.startPos == -1L) {
            if (this.endPos == -1L) {
                this.valid = false;
            } else {
                this.forward = false;
            }
        } else if (this.endPos != -1L && this.startPos > this.endPos) {
            this.valid = false;
        }
        if (!this.forward) {
            this.setRangeForLastNBytes();
        }
    }

    private boolean isValidRangeString(String range) {
        return range == null || range.length() == 0 || range.indexOf(45) == -1;
    }

    private void setRangeForLastNBytes() {
        if (this.docSize > 1L) {
            this.startPos = this.docSize - this.endPos;
            this.endPos = this.docSize - 1L;
            this.forward = true;
        } else {
            this.valid = false;
        }
    }

    private void parsePositions(String range) {
        String[] positions = range.trim().split("-", 2);
        this.startPos = this.parsePosition(positions[0]);
        this.endPos = this.parsePosition(positions[1]);
    }

    private long parsePosition(String position) {
        long nPos = -1L;
        if (position != null && position.length() > 0) {
            try {
                nPos = Long.parseLong(position);
                if (nPos < 0L) {
                    this.valid = false;
                }
            }
            catch (NumberFormatException e) {
                this.valid = false;
            }
        }
        return nPos;
    }
}

