/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryService;

import com.ibm.cognos.cm.repositoryService.ByteRange;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.CountingInputStream;

public class ByteRangeInputStream
extends InputStream {
    private final CountingInputStream contentStream;
    private final ByteRange byteRange;
    private final boolean last;

    public ByteRangeInputStream(CountingInputStream contentStream, ByteRange byteRange, boolean last) {
        this.contentStream = contentStream;
        this.byteRange = byteRange;
        this.last = last;
    }

    @Override
    public int read() throws IOException {
        this.synchStreamToRangeIfRequired();
        if (this.contentStream.getByteCount() <= this.byteRange.getEndPos()) {
            return this.contentStream.read();
        }
        return -1;
    }

    @Override
    public void close() throws IOException {
        if (this.last) {
            this.contentStream.close();
        }
    }

    @Override
    public int available() throws IOException {
        this.synchStreamToRangeIfRequired();
        if (this.contentStream.getByteCount() <= this.byteRange.getEndPos()) {
            return this.contentStream.available();
        }
        return -1;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.synchStreamToRangeIfRequired();
        len = (int)Math.min((long)len, this.byteRange.getEndPos() - this.contentStream.getByteCount() + 1L);
        if (len > 0) {
            return this.contentStream.read(b, off, len);
        }
        return -1;
    }

    private void synchStreamToRangeIfRequired() throws IOException {
        if (this.contentStream.getByteCount() < this.byteRange.getStartPos()) {
            long skipCount;
            long skipped;
            while ((skipped = this.contentStream.skip(skipCount = this.byteRange.getStartPos() - this.contentStream.getByteCount())) < skipCount && skipped > 0L) {
            }
            if (this.contentStream.getByteCount() < this.byteRange.getStartPos()) {
                throw new IOException("Unable to skip to specified range");
            }
        }
    }
}

