/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryService;

import com.ibm.cognos.cm.repositoryService.ByteRange;
import com.ibm.cognos.cm.repositoryService.ByteRangeInputStream;
import com.ibm.cognos.cm.repositoryService.HTTPHeaders;
import com.ibm.cognos.cm.repositoryService.HeaderName;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.commons.lang.StringUtils;

public class ByteRangeProcessor {
    private List<ByteRange> ranges = new ArrayList<ByteRange>();
    private boolean valid = true;
    private long docSize = -1L;
    private final String rangeHeader;

    public ByteRangeProcessor(String rangeHeader, long docSize) {
        this.rangeHeader = rangeHeader;
        this.setDocSize(docSize);
    }

    public ByteRangeProcessor(String rangeHeader) {
        this(rangeHeader, -1L);
    }

    public boolean isValidRangeRequest() {
        return this.valid;
    }

    public List<ByteRange> getRanges() {
        return this.ranges;
    }

    public int getNumberOfRanges() {
        return this.ranges.size();
    }

    public final void setDocSize(long docSize) {
        this.docSize = docSize;
        this.parse(this.rangeHeader);
    }

    final void parse(String rangeHeader) {
        this.parseRangeHeader(rangeHeader);
        this.sortRanges();
        this.mergeOverlappingRanges();
    }

    public final void parseRangeHeader(String rangeHeader) {
        String[] allRanges;
        if (!this.isValidHeader(rangeHeader)) {
            return;
        }
        String rangeValue = rangeHeader;
        rangeValue = rangeValue.trim();
        rangeValue = rangeValue.substring("bytes=".length()).trim();
        this.ranges.clear();
        for (String range : allRanges = rangeValue.split(",")) {
            ByteRange byteRange = new ByteRange(range, this.docSize);
            if (!byteRange.isValid()) {
                this.invalidate();
                break;
            }
            this.ranges.add(byteRange);
        }
        this.valid = this.ranges.size() != 0;
    }

    private boolean isValidHeader(String rangeHeader) {
        if (StringUtils.isEmpty((String)rangeHeader) || !rangeHeader.toLowerCase().startsWith("bytes=") || rangeHeader.indexOf(45) == -1) {
            this.valid = false;
            return this.valid;
        }
        return true;
    }

    public boolean processRanges(List<InputStream> attachmentList, InputStream contentStream, HTTPHeaders headers) throws IOException {
        ByteRange range;
        this.parse(this.rangeHeader);
        if (!this.valid || this.ranges.size() == 0) {
            return false;
        }
        CountingInputStream countingContentStream = new CountingInputStream(contentStream);
        int nRanges = this.ranges.size();
        headers.remove(new HeaderName("Content-Length"));
        if (nRanges > 1) {
            String contentType = headers.get("Content-Type");
            headers.clear();
            headers.put("Content-Type", contentType);
        }
        for (int i = 0; i < nRanges && this.processRange(range = this.ranges.get(i), attachmentList, countingContentStream, headers, i == nRanges - 1); ++i) {
        }
        return true;
    }

    public boolean processRange(ByteRange range, List<InputStream> attachmentList, CountingInputStream contentStream, HTTPHeaders headers, boolean last) throws IOException {
        long endPos = range.getEndPos();
        if (endPos == -1L) {
            if (this.docSize == -1L) {
                return false;
            }
            endPos = (int)this.docSize - 1;
            range.setEndPos(endPos);
        }
        long startPos = range.getStartPos();
        headers.put("Content-Range", "bytes " + startPos + "-" + endPos + "/" + this.getTotalSize(this.docSize));
        ByteRangeInputStream is = new ByteRangeInputStream(contentStream, range, last);
        SequenceInputStream content = new SequenceInputStream(new ByteArrayInputStream(headers.toByteArray()), is);
        attachmentList.add(content);
        return true;
    }

    private String getTotalSize(long docSize) {
        String totalSize = "*";
        if (docSize > 0L) {
            totalSize = String.valueOf(docSize);
        }
        return totalSize;
    }

    private void mergeOverlappingRanges() {
        boolean discard;
        if (!this.valid || this.ranges.size() < 2) {
            return;
        }
        ListIterator<ByteRange> it = this.ranges.listIterator();
        ByteRange previous = it.next();
        boolean bl = discard = previous.getEndPos() == -1L;
        while (it.hasNext()) {
            ByteRange current = it.next();
            if (discard) {
                it.remove();
                continue;
            }
            if (current.getEndPos() == -1L) {
                discard = true;
            }
            if (current.getStartPos() <= previous.getEndPos()) {
                long endPos = current.getEndPos();
                if (endPos > 0L) {
                    endPos = Math.max(current.getEndPos(), previous.getEndPos());
                }
                previous.setEndPos(endPos);
                it.remove();
                continue;
            }
            previous = current;
        }
    }

    private void invalidate() {
        this.ranges.clear();
        this.valid = false;
    }

    public final void sortRanges() {
        if (!this.valid || this.ranges.size() == 0) {
            return;
        }
        Collections.sort(this.ranges, new ByteRangeComparator());
    }

    private class ByteRangeComparator
    implements Comparator<ByteRange> {
        private ByteRangeComparator() {
        }

        @Override
        public int compare(ByteRange byteRange1, ByteRange byteRange2) {
            return (int)(byteRange1.getStartPos() - byteRange2.getStartPos());
        }
    }
}

