/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryService;

import com.ibm.cognos.cm.repositoryService.HeaderName;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpParser;

public class HTTPHeaders
extends LinkedHashMap<HeaderName, String> {
    private static final String MHT_MIME_TYPE = "message/rfc822";

    public HTTPHeaders() {
    }

    public HTTPHeaders(Properties headers) {
        super(headers.size(), 1.0f);
        this.putAll(headers);
    }

    public HTTPHeaders(Map<String, String> headers) {
        super(headers.size(), 1.0f);
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            this.put(new HeaderName(entry.getKey()), entry.getValue());
        }
    }

    public HTTPHeaders(InputStream is) throws HttpException, IOException {
        Header[] headers = HttpParser.parseHeaders((InputStream)is, (String)"UTF-8");
        this.putAll(headers);
    }

    public void putAll(HTTPHeaders headers) {
        this.putAll(headers);
    }

    public void putAll(Header[] headers) {
        for (Header header : headers) {
            this.put(new HeaderName(header.getName()), header.getValue());
        }
    }

    public void putAll(Properties headers) {
        for (Map.Entry<Object, Object> entry : headers.entrySet()) {
            this.put(new HeaderName((String)entry.getKey()), (String)entry.getValue());
        }
    }

    public boolean containsKey(String key) {
        return this.containsKey(new HeaderName(key));
    }

    public byte[] toByteArray() throws UnsupportedEncodingException {
        StringBuilder buffer = new StringBuilder();
        if (this.size() > 0) {
            for (Map.Entry entry : this.entrySet()) {
                buffer.append(entry.getKey());
                buffer.append(": ");
                buffer.append((String)entry.getValue());
                buffer.append("\r\n");
            }
            buffer.append("\r\n");
        }
        return buffer.toString().getBytes("UTF-8");
    }

    public long getDocumentSize() {
        long docSize = -1L;
        String sContentLength = this.get("Content-Length");
        docSize = sContentLength != null && sContentLength.length() > 0 ? Long.parseLong(sContentLength) : this.getSizeFromDispositionHeader();
        return docSize;
    }

    private long getSizeFromDispositionHeader() {
        int idx1;
        long docSize = -1L;
        String sContentDisposition = this.get("Content-Disposition");
        if (sContentDisposition != null && sContentDisposition.length() > 0 && (idx1 = sContentDisposition.indexOf("size=")) >= 0) {
            int idx2 = sContentDisposition.indexOf(59, idx1 += "size=".length());
            String sSize = idx2 != -1 ? sContentDisposition.substring(idx1, idx2) : sContentDisposition.substring(idx1);
            docSize = Long.parseLong(sSize);
        }
        return docSize;
    }

    public String get(String headerName) {
        return (String)this.get(new HeaderName(headerName));
    }

    @Override
    public String put(String name, String value) {
        return this.put(new HeaderName(name), value);
    }

    public boolean isCompressed() {
        String headerValue = this.get("Content-Encoding");
        return headerValue != null && headerValue.startsWith("gzip");
    }

    public boolean isMHT() {
        String headerValue = this.get("Content-Type");
        return headerValue != null && headerValue.startsWith(MHT_MIME_TYPE);
    }

    public void removeCacheControlHeader() {
        this.remove(new HeaderName("Cache-control"));
    }

    public void remove(String key) {
        this.remove(new HeaderName(key));
    }
}

