/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryService;

import com.cognos.pogo.handlers.contentmanager.viewer.ContentDispositionCreator;
import com.ibm.cognos.cm.repositoryService.HTTPHeaders;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HeaderHelper {
    private static final Pattern NAME_SIZE_PATTERN = Pattern.compile("(?:filename(?:(?:[*]=[Uu][Tt][Ff]-8'')|(?:=[\"']))([^;'\"]+))|(size=[0-9]+)");

    public static HTTPHeaders parse(InputStream is) throws IOException {
        HTTPHeaders headers = new HTTPHeaders(is);
        return headers;
    }

    public static String rebuildDispositionHeader(String originalDispHeader, String contentType, String userAgent, boolean asAttachment) {
        String size = null;
        String filename = "";
        Matcher dispositionMatcher = NAME_SIZE_PATTERN.matcher(originalDispHeader);
        while (dispositionMatcher.find()) {
            if (dispositionMatcher.group(1) != null) {
                try {
                    filename = URLDecoder.decode(dispositionMatcher.group(1), "utf-8");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (dispositionMatcher.group(2) == null) continue;
            size = dispositionMatcher.group(2);
        }
        String dispositionValue = HeaderHelper.createContentDisposition(contentType, userAgent, filename, asAttachment);
        if (size != null) {
            dispositionValue = dispositionValue + "; " + size;
        }
        return dispositionValue;
    }

    private static String createContentDisposition(String contentType, String userAgent, String filename, boolean asAttachment) {
        ContentDispositionCreator.DispositionType disposition = asAttachment ? ContentDispositionCreator.DispositionType.attachment : ContentDispositionCreator.DispositionType.inline;
        ContentDispositionCreator dispositionCreator = new ContentDispositionCreator(contentType, filename, disposition);
        String dispositionValue = dispositionCreator.createContentDisposition(userAgent);
        return dispositionValue;
    }
}

