/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryService.IPFLogging;

import com.ibm.cognos.cm.repositoryService.IPFLogging.StringMapping;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContentTypeToFormatMapper {
    private static final Log log = LogFactory.getLog(ContentTypeToFormatMapper.class);
    private static final String DEFAULT_FORMAT = "XHTML";
    private final List<StringMapping> mappings;

    public ContentTypeToFormatMapper(List<StringMapping> mappings) {
        this.mappings = mappings;
    }

    public String formatOf(String contentType) {
        if (StringUtils.isEmpty((String)contentType)) {
            return DEFAULT_FORMAT;
        }
        for (StringMapping mapping : this.mappings) {
            if (!contentType.startsWith(mapping.getPattern())) continue;
            return mapping.getResult();
        }
        log.warn((Object)("unrecognized content type: " + contentType));
        return DEFAULT_FORMAT;
    }
}

