/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryService.IPFLogging;

import com.cognos.cmutils.log.LogKitACLBridge;
import com.cognos.cmutils.log.LogKitACLBridgeFactory;
import com.ibm.cognos.cm.repositoryService.IPFLogging.StringMapping;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;

public class MappingLoader {
    private static LogKitACLBridge log = LogKitACLBridgeFactory.getLog(MappingLoader.class);
    static final String PREFIX = "contentTypeMapping";
    static final String PREFIX_FMT = "contentTypeMapping%d.";
    static final String SEPARATOR = "==>";
    private ArrayList<StringMapping> mappers = new ArrayList();
    private final ResourceBundle resBund;

    public MappingLoader(ResourceBundle resBund) {
        this.resBund = resBund;
    }

    public List<StringMapping> load() {
        if (this.resBund != null) {
            Enumeration<String> keys = this.resBund.getKeys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                if (!key.startsWith(PREFIX)) continue;
                this.addMapping(this.resBund.getString(key));
            }
        }
        return this.mappers;
    }

    private void addMapping(String mapping) {
        String[] pair = mapping.split(SEPARATOR, 2);
        if (pair.length != 2) {
            log.warn((Object)("ignoring invalid content type to format mapping: " + mapping));
            return;
        }
        String format = pair[1].trim();
        String contentType = pair[0].trim();
        if (StringUtils.isEmpty((String)format) || StringUtils.isEmpty((String)contentType)) {
            log.warn((Object)("ignoring invalid content type to format mapping: " + mapping));
            return;
        }
        log.debug((Object)String.format("add mapping from content type %s to format %s", contentType, format));
        this.mappers.add(new StringMapping(contentType, format));
    }
}

