/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryService.IPFLogging;

import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.repositoryPluginFramework.IPluginResourceLoader;
import com.cognos.pogo.pdk.MessageContext;
import com.ibm.cognos.cm.repositoryService.IPFLogging.ContentTypeToFormatMapper;
import com.ibm.cognos.cm.repositoryService.connection.CMConnectionDataProvider;
import com.ibm.cognos.cm.repositoryService.connection.CMConnectionProvider;
import com.ibm.cognos.cm.repositoryService.connection.RepositoryConnectionProvider;
import com.ibm.cognos.cm.repositoryService.rest.resource.OutputRequestType;
import com.ibm.cognos.cm.repositoryService.rest.resource.RepositoryServiceResource;
import com.ibm.cognos.cm.repositoryService.rest.resource.ResourceName;
import com.ibm.cognos.cm.repositoryService.rest.resource.URIResource;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OutputAuditInfo {
    private static final Log log = LogFactory.getLog(OutputAuditInfo.class);
    public AuditData ipfData = null;
    private ContentTypeToFormatMapper contentTypeToFormatMapper;

    private String getSearchPathFromCM(String storeID, RepositoryConnectionProvider connectionProvider) {
        String searchPath = null;
        try {
            if (connectionProvider instanceof CMConnectionProvider) {
                CMConnectionDataProvider cmConnProvider = ((CMConnectionProvider)connectionProvider).getConnectionDataProvider();
                searchPath = cmConnProvider.getSearchPath(storeID);
            }
        }
        catch (RepositoryException ex) {
            log.debug((Object)ex.getLocalizedMessage(), (Throwable)ex);
        }
        return searchPath;
    }

    public AuditData getSavedOutputAuditData(RepositoryConnectionProvider connectionProvider, IPluginResourceLoader resourceLoader, MessageContext messageContext) {
        AuditData ipfData = null;
        String urlPath = messageContext.getStrProperty("path_info");
        try {
            urlPath = URIUtil.encodePath((String)urlPath, (String)"UTF-8");
        }
        catch (URIException e) {
            log.debug((Object)("Invalid output resource URL: " + urlPath), (Throwable)e);
        }
        RepositoryServiceResource resource = new RepositoryServiceResource(urlPath, connectionProvider, messageContext, resourceLoader);
        URIResource uriResource = resource.getURIResource();
        if (this.isSavedInCM(resource) && this.isOutput(uriResource) && this.isContentRequest(uriResource)) {
            ipfData = new AuditData();
            String storeID = uriResource.getResourceId();
            ipfData.searchPath = this.getSearchPathFromCM(storeID, connectionProvider);
            ipfData.reportFormat = this.guessOutputFormat(messageContext);
            ipfData.storeID = storeID;
        }
        return ipfData;
    }

    private boolean isContentRequest(URIResource uriResource) {
        String requestType = uriResource.getParameter("outputRequestType");
        return OutputRequestType.CONTENT.name().equals(requestType) || OutputRequestType.MHT_CONTENT.name().equals(requestType);
    }

    private boolean isOutput(URIResource uriResource) {
        return ResourceName.OUTPUT.equals((Object)uriResource.getResourceName());
    }

    private boolean isSavedInCM(RepositoryServiceResource resource) {
        String repoID = resource.getDataSourceID();
        return "cm".equals(repoID);
    }

    public void setContentTypeToFormatMapper(ContentTypeToFormatMapper contentTypeToFormatMapper) {
        this.contentTypeToFormatMapper = contentTypeToFormatMapper;
    }

    private String guessOutputFormat(MessageContext messageContext) {
        if (this.contentTypeToFormatMapper == null) {
            return "XHTML";
        }
        return this.contentTypeToFormatMapper.formatOf(messageContext.getStrProperty("4audit.content-type"));
    }

    public static class AuditData {
        public String searchPath;
        public String reportFormat;
        public String storeID;
    }
}

