/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryService.IPFLogging;

import com.cognos.cmutils.messages.Message;
import com.cognos.indications.LogAuditAccessIndication;
import com.cognos.indications.LogTypedLogger;
import com.ibm.cognos.cm.repositoryService.IPFLogging.OutputAuditInfo;
import com.ibm.cognos.cm.repositoryService.RepositoryHandler;
import com.ibm.cognos.cm.repositoryService.RepositoryServiceVersion;
import java.util.Locale;

public class RepositoryServiceIPFLogging
extends LogAuditAccessIndication {
    private static final String SERVICE_NAME = "REPS";
    protected static LogTypedLogger auditLogger_;
    protected static LogTypedLogger serviceLogger_;
    protected static final String IPF_COMP_CRS = "ECM_VIEW";
    private static final String IPF_OBJ_TYPE = "ARCHIVED_DOCUMENT";
    public static final String IPF_OBJ_TYPE_REPORT = "Report";
    protected static boolean bInitialized_;
    protected static LogAuditAccessIndication indication_;
    OutputAuditInfo.AuditData savedOutputAuditInfo = null;

    public RepositoryServiceIPFLogging() {
        this.createIPFBasics();
        this.prepareIndication();
    }

    protected boolean isInitialized() {
        return bInitialized_;
    }

    protected LogTypedLogger getAuditLogger() {
        if (auditLogger_ == null) {
            auditLogger_ = LogTypedLogger.getInstance((String)"Audit.RTUsage.ECM_VIEW", LogAuditAccessIndication.class);
        }
        return auditLogger_;
    }

    protected LogAuditAccessIndication getLogIndication() {
        if (indication_ == null) {
            indication_ = new LogAuditAccessIndication(IPF_COMP_CRS, this.getBuildNumber());
        }
        return indication_;
    }

    protected void createIPFBasics() {
        if (!this.isInitialized()) {
            bInitialized_ = true;
            indication_ = new LogAuditAccessIndication(IPF_COMP_CRS, this.getBuildNumber());
            auditLogger_ = LogTypedLogger.getInstance((String)"Audit.RTUsage.ECM_VIEW", LogAuditAccessIndication.class);
            serviceLogger_ = LogTypedLogger.getInstance((String)("Audit.Other.DISP." + RepositoryHandler.class.getName()), LogAuditAccessIndication.class);
        }
    }

    private void prepareIndication() {
        indication_.setOperation("VIEW");
        indication_.setObjectType(IPF_OBJ_TYPE);
        indication_.setLevel(30000);
    }

    public void audit(String sessionID, String objectPath, String requestID, String status, String reportFormat, String[] errorMessages) throws Exception {
        if (requestID == null) {
            requestID = " ";
        }
        if (sessionID == null) {
            sessionID = " ";
        }
        if (this.isAuditLogEnabled()) {
            indication_.setSessionID(sessionID);
            indication_.setRequestID(requestID);
            indication_.setStatus(status);
            String objPath = objectPath;
            String storeID = null;
            if (this.savedOutputAuditInfo != null) {
                objPath = this.savedOutputAuditInfo.searchPath;
                indication_.setObjectType(IPF_OBJ_TYPE_REPORT);
                reportFormat = this.savedOutputAuditInfo.reportFormat;
                storeID = this.savedOutputAuditInfo.storeID;
            }
            indication_.setObjectPath(objPath);
            indication_.setLogData(this.createLogDataXML(reportFormat, storeID));
            indication_.setErrorMessage(this.getMessageXML(errorMessages));
            auditLogger_.log((Object)indication_);
        }
    }

    public void logServiceStartMessage(Message message) {
        this.logServiceStatus("StartService", message, "Info");
    }

    private void logServiceStatus(String operation, Message message, String status) {
        if (serviceLogger_.isEnabled(50000)) {
            LogAuditAccessIndication msg = new LogAuditAccessIndication(SERVICE_NAME, this.getBuildNumber());
            msg.setOperation(operation);
            msg.setStatus(status);
            msg.setLevel(50000);
            msg.setLogData(message.format(Locale.getDefault()));
            serviceLogger_.log((Object)msg);
        }
    }

    protected String createLogDataXML(String reportFormat, String storeID) {
        if (reportFormat == null || reportFormat.trim().length() <= 0) {
            return "";
        }
        StringBuilder parameters = new StringBuilder();
        parameters.append("<parameters><item name=\"reportFormat\">");
        parameters.append("<![CDATA[");
        parameters.append(reportFormat);
        parameters.append("]]></item>");
        parameters.append("<item name=\"storeID\">");
        parameters.append("<![CDATA[");
        parameters.append(storeID);
        parameters.append("]]></item>");
        parameters.append("</parameters>");
        return parameters.toString();
    }

    protected String getMessageXML(String[] errorMessages) {
        StringBuilder sb = new StringBuilder();
        if (errorMessages != null && errorMessages.length > 0) {
            int nIdx = 0;
            for (nIdx = 0; nIdx < errorMessages.length; ++nIdx) {
                String sMsg = errorMessages[nIdx];
                sb.append("<message>");
                sb.append(sMsg);
                sb.append("</message>");
            }
        }
        return sb.toString();
    }

    public int getBuildNumber() {
        return RepositoryServiceVersion.getVersion();
    }

    public LogAuditAccessIndication getIndication() {
        return indication_;
    }

    public LogTypedLogger getLogger() {
        return auditLogger_;
    }

    public boolean isAuditLogEnabled() {
        return auditLogger_.isEnabled(30000);
    }

    public void setExtraInfo(OutputAuditInfo.AuditData auditData) {
        this.savedOutputAuditInfo = auditData;
    }

    static {
        bInitialized_ = false;
    }
}

