/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryService;

import com.cognos.cm.repositoryPluginAPI.IRepositoryHttpClientFactory;
import com.cognos.cm.repositoryPluginAPI.RepositoryConnection;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.repositoryPluginAPI.RepositoryHttpClientFactory;
import com.cognos.cm.repositoryPluginAPI.RepositoryUnauthorizedException;
import com.cognos.cm.repositoryPluginFramework.IPluginResourceLoader;
import com.cognos.cmutils.http.HttpClientFactory;
import com.cognos.cmutils.http.HttpClientFactoryProvider;
import com.cognos.cmutils.http.HttpMethodFactory;
import com.cognos.cmutils.log.LogKitACLBridge;
import com.cognos.cmutils.log.LogKitACLBridgeFactory;
import com.cognos.cmutils.messages.Message;
import com.cognos.cmutils.messages.Resource;
import com.cognos.cmutils.system.SystemUtils;
import com.cognos.cmutils.url.FileURIUtils;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.ibm.cognos.cm.repositoryService.IPFLogging.ContentTypeToFormatMapper;
import com.ibm.cognos.cm.repositoryService.IPFLogging.MappingLoader;
import com.ibm.cognos.cm.repositoryService.IPFLogging.OutputAuditInfo;
import com.ibm.cognos.cm.repositoryService.IPFLogging.RepositoryServiceIPFLogging;
import com.ibm.cognos.cm.repositoryService.RepositoryServiceErrors;
import com.ibm.cognos.cm.repositoryService.RepositoryServiceResourceLoader;
import com.ibm.cognos.cm.repositoryService.authorization.AuthorizationAdapter;
import com.ibm.cognos.cm.repositoryService.authorization.AuthorizationAdapterFactory;
import com.ibm.cognos.cm.repositoryService.cache.CacheProvider;
import com.ibm.cognos.cm.repositoryService.connection.CMConnectionProviderFactory;
import com.ibm.cognos.cm.repositoryService.connection.RepositoryConnectionProvider;
import com.ibm.cognos.cm.repositoryService.connection.RepositoryConnectionProviderFactory;
import com.ibm.cognos.cm.repositoryService.errorhandler.BasicRepositoryErrorHandler;
import com.ibm.cognos.cm.repositoryService.errorhandler.RepositoryErrorHandler;
import com.ibm.cognos.cm.repositoryService.jmx.MBeanRegister;
import com.ibm.cognos.cm.repositoryService.jmx.ServiceControl;
import com.ibm.cognos.cm.repositoryService.messagecontext.BasicMessageContextHelper;
import com.ibm.cognos.cm.repositoryService.messagecontext.MessageContextHelper;
import com.ibm.cognos.cm.repositoryService.rest.RepositoryServiceHandlerFactory;
import com.ibm.cognos.cm.repositoryService.rest.RequestHandlerFactory;
import com.ibm.cognos.cm.repositoryService.rest.ResourceRequestHandler;
import com.ibm.cognos.cm.repositoryService.rest.resource.ResourceException;
import com.ibm.cognos.cm.repositoryService.service.CryptoHelper;
import com.ibm.cognos.cm.repositoryService.service.CryptoHelperFactory;
import com.ibm.cognos.cm.repositoryService.service.PassportValidationResult;
import com.ibm.cognos.cm.repositoryService.service.PassportValidator;
import java.util.ArrayList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.lang.StringUtils;

public class RepositoryHandler
extends BasicHandler {
    private static LogKitACLBridge log = LogKitACLBridgeFactory.getLog(RepositoryHandler.class);
    private static final String CONFIG_PARAM_CM_URL = "contentManager";
    private static final String CONFIG_PARAM_GATEWAY = "gateway";
    private static final String CONFIG_PARAM_INTERNAL_DISP_URL = "internalDispatcher";
    private static final String EMPTY_STRING = "";
    static final String CONFIG_PARAM_UNIX_URI = "unixRepositoryURI";
    static final String CONFIG_PARAM_WINURI = "windowsRepositoryURI";
    private static final String BUNDLE_NAME = "com.ibm.cognos.cm.repositoryService.RepositoryServiceInternal";
    private static String cmRestURI;
    private RepositoryServiceIPFLogging IPFLogger_ = null;
    private String contentTypeForIPF_ = "";
    private HttpMethodFactory httpMethodFactory;
    private final AuthorizationAdapter authorizationAdapter;
    private final RepositoryConnectionProviderFactory connectionProviderFactory;
    private final CryptoHelper cryptoHelper;
    private final MessageContextHelper messageContextHelper;
    private final RepositoryErrorHandler errorHandler;
    private final RequestHandlerFactory handlerFactory;
    private IPluginResourceLoader resourceLoader;
    private CacheProvider cacheProvider = null;
    private String gatewayConfigURL = null;
    private String internalDispConfigURL = null;
    private String externalObjectStoreURI;
    private OutputAuditInfo extraOutputInfoForAudit = null;
    private boolean isEOSEnabled = false;
    private PassportValidator passportValidator;

    public RepositoryHandler() {
        this(HttpClientFactoryProvider.getInstance(), new AuthorizationAdapterFactory().getAdapterInstance(), new CMConnectionProviderFactory(), new CryptoHelperFactory().getHelperInstance(), BasicMessageContextHelper.getInstance(), new BasicRepositoryErrorHandler(), CacheProvider.getInstance(), new RepositoryServiceIPFLogging(), RepositoryServiceHandlerFactory.getInstance(), new OutputAuditInfo(), new PassportValidator());
    }

    public RepositoryServiceIPFLogging getIPFLogger_() {
        return this.IPFLogger_;
    }

    RepositoryHandler(HttpClientFactory httpClientFactory, AuthorizationAdapter authorizationAdapter, RepositoryConnectionProviderFactory connectionProviderFactory, CryptoHelper cryptoHelper, MessageContextHelper messageContextHelper, RepositoryErrorHandler errorHandler, CacheProvider cacheProvider, RepositoryServiceIPFLogging IPFLogger, RequestHandlerFactory uriParser, OutputAuditInfo outputAuditInfo, PassportValidator passportValidator) {
        super(log.getLogKitLogger());
        this.httpMethodFactory = httpClientFactory.getHttpMethodFactory(null);
        this.authorizationAdapter = authorizationAdapter;
        this.authorizationAdapter.setHttpMethodFactory(this.httpMethodFactory);
        this.connectionProviderFactory = connectionProviderFactory;
        this.connectionProviderFactory.setHttpMethodFactory(this.httpMethodFactory);
        RepositoryHttpClientFactory repositoryHttpClientFactory = new RepositoryHttpClientFactory(httpClientFactory);
        this.connectionProviderFactory.setRepositoryHttpClientFactory((IRepositoryHttpClientFactory)repositoryHttpClientFactory);
        this.cryptoHelper = cryptoHelper;
        this.messageContextHelper = messageContextHelper;
        this.errorHandler = errorHandler;
        this.cacheProvider = cacheProvider;
        this.IPFLogger_ = IPFLogger;
        this.handlerFactory = uriParser;
        this.extraOutputInfoForAudit = outputAuditInfo;
        this.passportValidator = passportValidator;
        ServiceControl.getInstance().setServiceHandler(this);
    }

    public void dispose() {
        this.cacheProvider.shutdown();
        this.cryptoHelper.dispose();
    }

    public void start() {
        super.start();
    }

    public void initialize() {
        super.initialize();
        try {
            this.cryptoHelper.initialize();
        }
        catch (RepositoryException e) {
            this.logFatalError(e.getRootStackTrace());
            throw new RuntimeException(e);
        }
        this.extraOutputInfoForAudit.setContentTypeToFormatMapper(this.makeContentTypeToFormatMapper());
        MBeanRegister.registerMBeans();
        this.testEOSConnection();
    }

    private ContentTypeToFormatMapper makeContentTypeToFormatMapper() {
        ResourceBundle resBundle = null;
        try {
            resBundle = ResourceBundle.getBundle(BUNDLE_NAME, new Locale("ov", "CA"));
        }
        catch (MissingResourceException mrx) {
            log.error((Object)"failed to load resource bundle: com.ibm.cognos.cm.repositoryService.RepositoryServiceInternal");
        }
        return new ContentTypeToFormatMapper(new MappingLoader(resBundle).load());
    }

    public void invokeImpl(MessageContext mc) throws PogoException {
        try {
            this.handleRequest(mc);
        }
        catch (ResourceException e) {
            this.handleResourceException(mc, e);
        }
        catch (RepositoryUnauthorizedException e) {
            this.handleInitialRepositoryUnauthorizedException(mc, e);
        }
        catch (RepositoryException e) {
            this.handleRepositoryException(mc, e);
        }
        catch (Exception e) {
            this.handleException(mc, e);
        }
    }

    private void handleRequest(MessageContext mc) throws RepositoryException {
        String passportID = this.messageContextHelper.getPassportIDFromCookies(mc);
        if (passportID == null) {
            Message err = new Message((Resource.Id)RepositoryServiceErrors.REPS_REP.repositoryMissingPassport);
            this.errorHandler.respond(mc, RepositoryServiceErrors.REPS_REP.repositoryMissingPassport, err);
            return;
        }
        String urlPath = this.getPath(mc);
        RepositoryServiceIPFLogging logger = this.getIPFLogger_();
        RepositoryConnectionProvider connectionProvider = this.connectionProviderFactory.getProviderInstance(this.cryptoHelper, mc);
        ResourceRequestHandler request = this.handlerFactory.create(this.httpMethodFactory, urlPath, mc, this.gatewayConfigURL, connectionProvider, this.resourceLoader, this.authorizationAdapter);
        request.setAuthorizationAdapter(this.authorizationAdapter);
        request.setResourceLoader(this.resourceLoader);
        request.handle(mc, connectionProvider);
        if (logger.isAuditLogEnabled()) {
            OutputAuditInfo.AuditData auditData = this.extraOutputInfoForAudit.getSavedOutputAuditData(connectionProvider, this.resourceLoader, mc);
            if (auditData != null) {
                logger.setExtraInfo(auditData);
            }
            this.auditLog("Success", mc, null);
        }
    }

    protected void auditLog(String sStatus, MessageContext mc, ArrayList<String> allMessages) {
        RepositoryServiceIPFLogging logger = this.getIPFLogger_();
        String urlPath = mc.getStrProperty("path_info");
        String requestID = this.messageContextHelper.getRequestContext(mc);
        String sessionID = this.messageContextHelper.getSessionContext(mc);
        if (this.needAuditLog(urlPath)) {
            String[] messages = null;
            if (allMessages != null) {
                messages = allMessages.toArray(new String[allMessages.size()]);
            }
            try {
                logger.audit(sessionID, urlPath, requestID, sStatus, this.contentTypeForIPF_, messages);
            }
            catch (Exception ex) {
                this.logFatalError(ex.getMessage());
            }
        }
    }

    private boolean needAuditLog(String urlPath) {
        boolean isContentRequest = urlPath.endsWith("/content");
        return isContentRequest;
    }

    protected void logFatalError(String detail) {
        log.error((Object)detail);
    }

    protected void logDebugInfo(String message, Throwable t) {
        log.debug((Object)message, t);
    }

    protected String getPath(MessageContext mc) {
        String path = mc.getStrProperty("path_info");
        try {
            path = URIUtil.encodePath((String)path, (String)"UTF-8");
        }
        catch (URIException e) {
            throw new ResourceException(400, new Message(e.getLocalizedMessage()));
        }
        BIBusEnvelope env = (BIBusEnvelope)mc.getProperty("request.envelope");
        String queryParams = env.getFormFieldValuesAsQueryString();
        StringBuilder builder = new StringBuilder();
        builder.append(path);
        if (queryParams != null && queryParams.length() > 0) {
            builder.append("?");
            builder.append(queryParams);
        }
        return builder.toString();
    }

    public void configure(Configuration configuration) {
        this.cacheProvider.configure(configuration);
        this.configureRuntimeParameters(configuration);
        this.handlerFactory.configure(configuration);
    }

    private void configureRuntimeParameters(Configuration configuration) {
        this.gatewayConfigURL = configuration.getValue(CONFIG_PARAM_GATEWAY);
        this.internalDispConfigURL = configuration.getValue(CONFIG_PARAM_INTERNAL_DISP_URL);
        this.setCMRestURI(configuration);
        this.setExternalObjectStoreURI(this.getEOSFileURI(configuration));
        this.setEOSEnabled(this.isEOSEnabled(configuration));
    }

    void setEOSEnabled(boolean isEOSEnabled) {
        this.isEOSEnabled = isEOSEnabled;
    }

    void setExternalObjectStoreURI(String externalObjectStoreURI) {
        this.externalObjectStoreURI = externalObjectStoreURI;
    }

    boolean isEOSEnabled(Configuration configuration) {
        String windowsURI = configuration.getValue(CONFIG_PARAM_WINURI);
        String unixURI = configuration.getValue(CONFIG_PARAM_UNIX_URI);
        return StringUtils.isNotEmpty((String)windowsURI) || StringUtils.isNotEmpty((String)unixURI);
    }

    private String getEOSFileURI(Configuration configuration) {
        String fileURI = SystemUtils.isRunningWindows() ? configuration.getValue(CONFIG_PARAM_WINURI) : configuration.getValue(CONFIG_PARAM_UNIX_URI);
        return fileURI;
    }

    public boolean testEOSConnection() {
        boolean isSuccessfulTest = true;
        if (this.isEOSEnabled) {
            RepositoryConnectionProvider connectionProvider = this.connectionProviderFactory.getProviderInstance(this.cryptoHelper, null);
            try {
                RepositoryConnection cmPluginconnection = connectionProvider.getConnection("cm", null, this.resourceLoader);
                cmPluginconnection.test();
            }
            catch (RepositoryException e) {
                Message message;
                String path = FileURIUtils.getPathFromURI((String)this.externalObjectStoreURI);
                if (StringUtils.isNotEmpty((String)path)) {
                    message = new Message((Resource.Id)RepositoryServiceErrors.REPS_CM.repositoryNoEOSAccess);
                    message.param("locationPath", path);
                    message.param("username", System.getProperty("user.name"));
                } else {
                    message = new Message((Resource.Id)RepositoryServiceErrors.REPS_CM.repositoryNoEOSUriConfiguredForThisOS);
                }
                this.getIPFLogger_().logServiceStartMessage(message);
                isSuccessfulTest = false;
            }
        }
        return isSuccessfulTest;
    }

    public void reconfigure(Configuration configuration) {
        this.cacheProvider.reconfigure(configuration);
        this.configureRuntimeParameters(configuration);
    }

    public void compose_impl(PogoEngine engine) throws PogoException {
        this.resourceLoader = new RepositoryServiceResourceLoader(engine.getContext());
    }

    public void setCMRestURI(Configuration configuration) {
        String cmURL = configuration.getValue(CONFIG_PARAM_CM_URL);
        cmRestURI = cmURL.replaceFirst("/servlet", "/cm");
        this.httpMethodFactory.setBaseURI(cmRestURI);
    }

    public static String getCMRestURI() {
        return cmRestURI;
    }

    public void setResourceLoader(IPluginResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    private void handleResourceException(MessageContext mc, ResourceException e) {
        Locale locale = (Locale)mc.getProperty("locale");
        ArrayList messages = e.getAllMessages(locale);
        if (this.getIPFLogger_().isAuditLogEnabled()) {
            this.auditLog("Failure", mc, messages);
        }
        this.logFatalError("Error processing URI path [" + this.getPath(mc) + "]: " + messages);
        this.logDebugInfo("ResourceException when parsing resource URI. " + e.getRootStackTrace(), (Throwable)((Object)e));
        this.errorHandler.respond(mc, e);
    }

    private void handleInitialRepositoryUnauthorizedException(MessageContext mc, RepositoryUnauthorizedException repoUnauthorizedException) {
        BIBusEnvelope requestEnvelope = (BIBusEnvelope)mc.getProperty("request.envelope");
        if (requestEnvelope == null) {
            this.logFatalError("The requestEnvelope is null, can not attempt passport validation");
            this.handleRepositoryException(mc, (RepositoryException)((Object)repoUnauthorizedException));
            return;
        }
        PassportValidationResult validateResponse = null;
        try {
            this.passportValidator.setDispatcherURL(this.internalDispConfigURL);
            validateResponse = this.passportValidator.validate(requestEnvelope);
            if (validateResponse.getStatusCode() == 200) {
                BIBusEnvelope responseEnvelope = validateResponse.getResponseEnvelope();
                if (responseEnvelope == null) {
                    this.logFatalError("The responseEnvelope of the passport validate request is null or invalid");
                    this.handleRepositoryException(mc, (RepositoryException)((Object)repoUnauthorizedException));
                    return;
                }
                mc.setProperty("request.envelope", (Object)responseEnvelope);
                mc.setProperty("auth.passportid", (Object)validateResponse.getPassportID());
                this.handleRequest(mc);
            } else if (validateResponse.isUserOrSystemRecoverableException()) {
                mc.setFault(new Fault(EMPTY_STRING, (SOAPEnvelope)validateResponse.getResponseEnvelope()));
            } else {
                this.logFatalError("The passport validate request failed with status code " + validateResponse.getStatusCode());
                this.handleRepositoryException(mc, (RepositoryException)((Object)repoUnauthorizedException));
            }
        }
        catch (ResourceException e) {
            this.handleResourceException(mc, e);
        }
        catch (RepositoryUnauthorizedException e) {
            if (validateResponse.isUserOrSystemRecoverableException()) {
                mc.setFault(new Fault(EMPTY_STRING, (SOAPEnvelope)validateResponse.getResponseEnvelope()));
            } else {
                this.handleRepositoryException(mc, (RepositoryException)((Object)e));
            }
        }
        catch (RepositoryException e) {
            this.handleRepositoryException(mc, e);
        }
        catch (Exception e) {
            this.handleException(mc, e);
        }
    }

    private void handleRepositoryException(MessageContext mc, RepositoryException e) {
        Locale locale = (Locale)mc.getProperty("locale");
        ArrayList messages = e.getAllMessages(locale);
        if (this.getIPFLogger_().isAuditLogEnabled()) {
            this.auditLog("Failure", mc, messages);
        }
        this.logFatalError("Service error when requesting resource: " + this.getPath(mc) + ". " + messages);
        this.logDebugInfo("RepositoryException when handling request." + e.getRootStackTrace(), e);
        this.errorHandler.respond(mc, e);
    }

    private void handleException(MessageContext mc, Exception e) {
        Locale locale = (Locale)mc.getProperty("locale");
        Message message = new Message((Resource.Id)RepositoryServiceErrors.REPS_REP.repositoryResourceRequestError);
        String cause = e.getLocalizedMessage();
        if (cause != null) {
            message.addDetail(cause);
        }
        if (this.getIPFLogger_().isAuditLogEnabled()) {
            this.auditLog("Failure", mc, message.formatAll(locale));
        }
        this.logFatalError("Exception when requesting resource: " + this.getPath(mc) + "." + e.getStackTrace());
        this.logDebugInfo("Exception when when handling request. " + e.getStackTrace(), e);
        this.errorHandler.respond(mc, message, e);
    }
}

