/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryService.authorization;

import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.repositoryPluginFramework.AccessControlHelper;
import com.cognos.cm.repositoryPluginFramework.identity.IdentityProvider;
import com.cognos.pogo.pdk.MessageContext;
import com.ibm.cognos.cm.repositoryService.authorization.AccessControl;
import com.ibm.cognos.cm.repositoryService.messagecontext.MessageContextHelper;
import com.ibm.cognos.internal.camaaa.accesscontrol.Identity;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public abstract class BaseAccessControl
implements AccessControl {
    protected final IdentityProvider identityProvider;
    protected final AccessControlHelper acmHelper;
    protected final MessageContextHelper contextHelper;

    protected BaseAccessControl(AccessControlHelper acmHelper, MessageContextHelper helper, IdentityProvider identityProvider) {
        this.acmHelper = acmHelper;
        this.contextHelper = helper;
        this.identityProvider = identityProvider;
    }

    @Override
    public boolean hasBurstAccess(MessageContext context, List<String> recipients, String owner) throws RepositoryException {
        Identity identity = this.identityProvider.getIdentity(context);
        if (this.acmHelper.isAdministrator(identity)) {
            return true;
        }
        HashSet<String> identitySet = new HashSet<String>(Arrays.asList(identity.getIdentities()));
        if (identitySet.contains(owner)) {
            return true;
        }
        HashSet<String> burstRecipients = new HashSet<String>(recipients);
        return !CollectionUtils.intersection(identitySet, burstRecipients).isEmpty();
    }
}

