/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryService.authorization;

import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.repositoryPluginFramework.AccessControlHelper;
import com.cognos.cm.repositoryPluginFramework.identity.IdentityProvider;
import com.cognos.cmutils.messages.Message;
import com.cognos.cmutils.messages.Resource;
import com.cognos.pogo.pdk.MessageContext;
import com.ibm.cognos.cm.repositoryService.RepositoryServiceErrors;
import com.ibm.cognos.cm.repositoryService.authorization.BaseAccessControl;
import com.ibm.cognos.cm.repositoryService.messagecontext.MessageContextHelper;
import com.ibm.cognos.internal.camaaa.accesscontrol.AccessControlException;
import com.ibm.cognos.internal.camaaa.accesscontrol.AccessControlModule;
import com.ibm.cognos.internal.camaaa.accesscontrol.Identity;
import com.ibm.cognos.internal.camaaa.accesscontrol.Policy;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class CAMAccessControl
extends BaseAccessControl {
    private final byte[] policies;
    private final AccessControlModule acm;
    private static Log log = LogFactory.getLog(BaseAccessControl.class);

    CAMAccessControl(AccessControlModule acm, AccessControlHelper acmHelper, MessageContextHelper contextHelper, IdentityProvider identityProvider, byte[] policies) {
        super(acmHelper, contextHelper, identityProvider);
        this.acm = acm;
        this.policies = policies;
    }

    @Override
    public boolean isAccessGranted(String passportID, String accessRequired, MessageContext context) throws RepositoryException {
        try {
            Element header = this.contextHelper.getRequestEnvelopeHeader(context);
            Identity id = this.acm.getIdentity(header);
            Policy policy = this.acm.getPolicy();
            this.initializePolicy(policy, this.policies);
            return policy.isAccessGranted(id, accessRequired);
        }
        catch (AccessControlException e) {
            throw this.logAndWrapException(RepositoryServiceErrors.REPS_REP.repositorySecurityError, (Exception)((Object)e));
        }
        catch (DocumentException e) {
            log.debug((Object)("Invalid policy: " + this.policies));
            throw this.logAndWrapException(RepositoryServiceErrors.REPS_REP.repositoryPolicyError, (Exception)((Object)e));
        }
    }

    private RepositoryException logAndWrapException(Resource.Id id, Exception e) {
        log.error((Object)e.getMessage(), (Throwable)e);
        Message msg = new Message(id);
        return new RepositoryException(msg, (Throwable)e);
    }

    private void initializePolicy(Policy policy, byte[] policies) throws DocumentException, AccessControlException {
        SAXReader reader = new SAXReader();
        Document policiesDoc = reader.read((InputStream)new ByteArrayInputStream(policies));
        policy.init(policiesDoc.getRootElement());
    }
}

