/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryService.authorization;

import com.cognos.cm.client.cmapi.HttpCommandFactory;
import com.cognos.cm.repositoryPluginFramework.AccessControlHelper;
import com.cognos.cm.repositoryPluginFramework.identity.ExternalIdentityProvider;
import com.cognos.cm.repositoryPluginFramework.identity.IdentityProvider;
import com.cognos.cmutils.http.HttpMethodFactory;
import com.ibm.cognos.cm.repositoryService.authorization.AccessControl;
import com.ibm.cognos.cm.repositoryService.authorization.AccessControlFactory;
import com.ibm.cognos.cm.repositoryService.authorization.BaseAccessControl;
import com.ibm.cognos.cm.repositoryService.authorization.CAMAccessControl;
import com.ibm.cognos.cm.repositoryService.authorization.DefaultAccessControl;
import com.ibm.cognos.cm.repositoryService.connection.CMAccessControl;
import com.ibm.cognos.cm.repositoryService.messagecontext.MessageContextHelper;
import com.ibm.cognos.internal.camaaa.accesscontrol.AccessControlModule;

public class DefaultAccessControlFactory
implements AccessControlFactory {
    private final AccessControlModule acm;
    private final MessageContextHelper contextHelper;
    private final AccessControlHelper acmHelper;

    DefaultAccessControlFactory(AccessControlModule acm, MessageContextHelper contextHelper) {
        this(acm, contextHelper, AccessControlHelper.getInstance());
    }

    DefaultAccessControlFactory(AccessControlModule acm, MessageContextHelper contextHelper, AccessControlHelper acmHelper) {
        this.acm = acm;
        this.contextHelper = contextHelper;
        this.acmHelper = acmHelper;
    }

    @Override
    public AccessControl getAccessControl(String storeID, byte[] policies, HttpMethodFactory httpMethodFactory) {
        if (storeID == null && policies == null) {
            throw new IllegalArgumentException("Must provide storeID or policies");
        }
        BaseAccessControl control = null;
        HttpCommandFactory commandFactory = new HttpCommandFactory(httpMethodFactory);
        ExternalIdentityProvider identityProvider = new ExternalIdentityProvider();
        identityProvider.setCommandFactory(commandFactory);
        control = policies != null && policies.length > 0 ? new CAMAccessControl(this.acm, this.acmHelper, this.contextHelper, (IdentityProvider)identityProvider, policies) : new CMAccessControl(storeID, this.contextHelper, this.acmHelper, (IdentityProvider)identityProvider, commandFactory);
        return control;
    }

    @Override
    public AccessControl getAccessControl(HttpMethodFactory httpMethodFactory) {
        HttpCommandFactory commandFactory = new HttpCommandFactory(httpMethodFactory);
        ExternalIdentityProvider identityProvider = new ExternalIdentityProvider();
        identityProvider.setCommandFactory(commandFactory);
        return new DefaultAccessControl(this.acmHelper, this.contextHelper, (IdentityProvider)identityProvider);
    }
}

