/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryService.authorization;

import com.cognos.cm.repositoryPluginAPI.IQueryResultObjects;
import com.cognos.cm.repositoryPluginAPI.RepositoryConnection;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.repositoryPluginFramework.SearchPathHelper;
import com.cognos.cmutils.http.HttpMethodFactory;
import com.cognos.pogo.pdk.MessageContext;
import com.ibm.cognos.cm.repositoryService.authorization.AccessControl;
import com.ibm.cognos.cm.repositoryService.authorization.AccessControlCache;
import com.ibm.cognos.cm.repositoryService.authorization.AccessControlCacheManager;
import com.ibm.cognos.cm.repositoryService.authorization.AccessControlFactory;
import com.ibm.cognos.cm.repositoryService.authorization.AuthorizationAdapter;
import com.ibm.cognos.cm.repositoryService.messagecontext.BasicMessageContextHelper;
import com.ibm.cognos.cm.repositoryService.messagecontext.MessageContextHelper;
import java.util.List;

class DefaultAuthorizationAdapter
implements AuthorizationAdapter {
    private static final AccessControlCache accessControlCache = AccessControlCacheManager.getNewCacheInstance();
    private final AccessControlFactory accessFactory;
    private MessageContextHelper contextHelper;
    private HttpMethodFactory httpMethodFactory;

    DefaultAuthorizationAdapter(AccessControlFactory accessFactory) {
        this(accessFactory, BasicMessageContextHelper.getInstance());
    }

    DefaultAuthorizationAdapter(AccessControlFactory accessFactory, MessageContextHelper contextHelper) {
        this.accessFactory = accessFactory;
        this.contextHelper = contextHelper;
    }

    @Override
    public boolean isGrantedAccess(String storeID, String accessRequired, MessageContext context, RepositoryConnection connection) throws RepositoryException {
        AccessControl control;
        String passportID = this.contextHelper.getPassportIDFromCookies(context);
        boolean accessGranted = accessControlCache.hasAccess(passportID, storeID);
        if (!accessGranted && (accessGranted = (control = this.accessFactory.getAccessControl(storeID, null, this.httpMethodFactory)).isAccessGranted(passportID, accessRequired, context))) {
            accessControlCache.put(passportID, storeID);
        }
        return accessGranted;
    }

    @Override
    public boolean hasBurstAccess(MessageContext context, IQueryResultObjects objects, HttpMethodFactory httpMethodFactory) throws RepositoryException {
        String recipientsXML = (String)objects.getPropertyValue("recipients");
        List recipients = new SearchPathHelper(recipientsXML).getValues();
        if (recipients == null) {
            return true;
        }
        String owner = (String)objects.getPropertyValue("owner");
        AccessControl control = this.accessFactory.getAccessControl(httpMethodFactory);
        return control.hasBurstAccess(context, recipients, owner);
    }

    @Override
    public void setHttpMethodFactory(HttpMethodFactory httpMethodFactory) {
        this.httpMethodFactory = httpMethodFactory;
    }
}

