/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryService.cache;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cmutils.log.LogKitACLBridge;
import com.ibm.cognos.cm.repositoryService.cache.Cache;
import com.ibm.cognos.cm.repositoryService.cache.CachedItem;
import com.ibm.cognos.cm.repositoryService.cache.CachedItemFactory;
import com.ibm.cognos.cm.repositoryService.cache.EhCacheDelegate;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import javax.mail.MessagingException;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;

abstract class BaseCache
implements Cache {
    public static final String MAX_CACHE_DOC_SIZE = "repository.maxCacheDocSize";
    public static final String REPOS_CACHE_OBJ_TTL = "reposCacheObjTTL";
    public static final String REPOS_NUM_OBJ_DISK = "reposNumObjDisk";
    public static final String REPOS_NUM_OBJ_MEM = "reposNumObjMem";
    static final int DEFAULT_MAX_CACHE_DOC_SIZE = 10;
    static final String LEAST_RECENTLY_USED = "LRU";
    EhCacheDelegate ehCacheDelegate;
    final CachedItemFactory itemFactory;
    protected long maxCacheDocSize = Long.MAX_VALUE;

    BaseCache(CachedItemFactory itemFactory) {
        this.itemFactory = itemFactory;
    }

    void setEhCacheDelegate(EhCacheDelegate ehCacheDelegate) {
        this.ehCacheDelegate = ehCacheDelegate;
    }

    EhCacheDelegate getEhCacheDelegate() {
        return this.ehCacheDelegate;
    }

    @Override
    public Element get(String cacheID) {
        if (this.ehCacheDelegate != null) {
            return this.ehCacheDelegate.get(cacheID);
        }
        return null;
    }

    @Override
    public Element put(String cacheID, InputStream is, boolean expandMHT, long expiry) throws IOException, MessagingException {
        if (this.ehCacheDelegate != null) {
            CachedItem item = this.itemFactory.createCachedItem(is, expandMHT);
            item.setExpiry(expiry);
            Element result = new Element((Serializable)((Object)cacheID.toString()), (Serializable)item);
            this.ehCacheDelegate.put(result);
            return result;
        }
        return null;
    }

    @Override
    public void remove(String cacheID) {
        if (this.ehCacheDelegate != null) {
            this.ehCacheDelegate.remove(cacheID);
        }
    }

    @Override
    public void clearAll() {
        if (this.ehCacheDelegate != null) {
            this.ehCacheDelegate.removeAll();
        }
    }

    @Override
    public long maxDocSize() {
        return this.maxCacheDocSize;
    }

    abstract LogKitACLBridge log();

    abstract CacheConfiguration createRepositoryCacheConfiguration() throws RepositoryException;

    void setMaxCacheDocSize(ICCLConfiguration config) {
        int megabytes = 10;
        try {
            String maxSizeMB = config.getValue(MAX_CACHE_DOC_SIZE, true);
            megabytes = maxSizeMB != null && maxSizeMB.length() > 0 ? Integer.valueOf(maxSizeMB.trim()) : 10;
        }
        catch (NumberFormatException e) {
            this.log().debug((Object)"repository.maxCacheDocSize setting was not a number. Default value [10] will be used.", (Throwable)e);
        }
        catch (CCLConfigurationException e) {
            this.log().debug((Object)"Error obtaining repository.maxCacheDocSize from Configuration. Default value [10] will be used.", (Throwable)e);
        }
        megabytes = megabytes <= 0 ? 10 : megabytes;
        this.maxCacheDocSize = megabytes * 1024 * 1024;
    }
}

