/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryService.cache;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationUtils;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cmutils.log.LogKitACLBridge;
import com.cognos.cmutils.log.LogKitACLBridgeFactory;
import com.cognos.cmutils.messages.Message;
import com.cognos.cmutils.messages.Resource;
import com.cognos.pogo.pdk.Configuration;
import com.ibm.cognos.cm.repositoryService.RepositoryServiceErrors;
import com.ibm.cognos.cm.repositoryService.cache.BaseCache;
import com.ibm.cognos.cm.repositoryService.cache.Cache;
import com.ibm.cognos.cm.repositoryService.cache.CacheType;
import com.ibm.cognos.cm.repositoryService.cache.CachedItemFactory;
import com.ibm.cognos.cm.repositoryService.cache.EhCacheDelegate;
import com.ibm.cognos.cm.repositoryService.cache.RepositoryCache;
import com.ibm.cognos.cm.repositoryService.cache.internal.CacheServiceConfiguration;
import com.ibm.cognos.cm.repositoryService.jmx.CacheControl;
import com.ibm.cognos.cm.repositoryService.rest.resource.ResourceException;
import java.io.File;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.config.ConfigurationFactory;
import net.sf.ehcache.config.DiskStoreConfiguration;

public class CacheProvider {
    private static LogKitACLBridge log = LogKitACLBridgeFactory.getLog(CacheProvider.class);
    private static final CacheProvider INSTANCE = new CacheProvider();
    private final Map<CacheType, Cache> cacheMap;
    private CacheServiceConfiguration config = null;
    private CacheManager cacheManager;

    CacheProvider() {
        this.cacheMap = new ConcurrentHashMap<CacheType, Cache>(CacheType.values().length);
        this.config = null;
    }

    CacheProvider(Map<CacheType, Cache> cacheMap, CacheServiceConfiguration config) {
        this.cacheMap = cacheMap;
        this.config = config;
    }

    public void configure(Configuration configuration) {
        this.config = this.getCacheServiceConfiguration(configuration);
        this.setupCache(configuration);
    }

    public void shutdown() {
        if (this.cacheManager != null) {
            this.cacheManager.shutdown();
        }
    }

    public void reconfigure(Configuration configuration) {
        try {
            if (this.config == null) {
                this.config = this.getCacheServiceConfiguration(configuration);
            } else {
                this.config.processConfiguration(configuration);
            }
            ICCLConfiguration icclConfig = configuration.getICCLConfiguration();
            for (Cache cache : this.cacheMap.values()) {
                cache.updateCacheProperties(icclConfig);
            }
        }
        catch (RepositoryException e) {
            log.fatal((Object)new Message(e.getCode()).format(Locale.getDefault()), (Throwable)e);
        }
    }

    public Cache get(CacheType cacheType) {
        return this.cacheMap.get((Object)cacheType);
    }

    private void setupCache(Configuration configuration) {
        ICCLConfiguration cognosConfiguration = configuration.getICCLConfiguration();
        net.sf.ehcache.config.Configuration ehCacheConfiguration = this.configureEHCache(cognosConfiguration);
        this.cacheManager = CacheManager.create((net.sf.ehcache.config.Configuration)ehCacheConfiguration);
        CachedItemFactory itemFactory = new CachedItemFactory(this.config);
        for (CacheType cacheType : CacheType.values()) {
            try {
                BaseCache cache = this.create(cacheType, itemFactory);
                this.setCacheDelegate(cache, this.cacheManager);
                this.cacheMap.put(cacheType, cache);
                CacheControl.getInstance().addCache(cache);
                cache.updateCacheProperties(cognosConfiguration);
            }
            catch (RepositoryException e) {
                log.fatal((Object)new Message(e.getCode()).format(Locale.getDefault()), (Throwable)e);
            }
        }
    }

    BaseCache create(CacheType type, CachedItemFactory itemFactory) {
        RepositoryCache cache = null;
        switch (type) {
            case REPOSITORY: {
                cache = new RepositoryCache(itemFactory);
                break;
            }
            default: {
                Message message = new Message((Resource.Id)RepositoryServiceErrors.REPS_REP.repositoryUnknownCache);
                message.param("cache", type.toString());
                throw new ResourceException(501, message);
            }
        }
        return cache;
    }

    void setCacheDelegate(BaseCache bCache, CacheManager cacheManager) {
        net.sf.ehcache.Cache ehCache = null;
        String cacheName = bCache.getType().toString();
        if (cacheManager.cacheExists(cacheName)) {
            ehCache = cacheManager.getCache(cacheName);
        } else {
            try {
                ehCache = new net.sf.ehcache.Cache(bCache.createRepositoryCacheConfiguration());
                cacheManager.addCache(ehCache);
            }
            catch (Exception e) {
                ehCache = null;
                Message message = new Message((Resource.Id)RepositoryServiceErrors.REPS_REP.repositoryUnknownCache);
                message.param("cache", cacheName);
                throw new ResourceException(501, message);
            }
        }
        if (ehCache != null) {
            bCache.setEhCacheDelegate(new EhCacheDelegate((Ehcache)ehCache));
        }
    }

    public CacheServiceConfiguration getCurrentConfig() {
        return this.config;
    }

    CacheServiceConfiguration getCacheServiceConfiguration(Configuration configuration) {
        return new CacheServiceConfiguration(configuration);
    }

    net.sf.ehcache.config.Configuration configureEHCache(ICCLConfiguration config) {
        String configFile = CCLConfigurationUtils.resolveEffectivePath((String)"../configuration/cache/reps_ehcache.xml");
        net.sf.ehcache.config.Configuration cConfig = ConfigurationFactory.parseConfiguration((File)new File(configFile));
        DiskStoreConfiguration dsConfig = new DiskStoreConfiguration();
        String dataDirectory = null;
        try {
            dataDirectory = config.getValue("data", true);
        }
        catch (CCLConfigurationException e) {
            dataDirectory = config.resolveEffectivePath("../data");
        }
        dsConfig.setPath(dataDirectory + "/ehcache");
        cConfig.addDiskStore(dsConfig);
        return cConfig;
    }

    public static CacheProvider getInstance() {
        return INSTANCE;
    }
}

