/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryService.cache;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.pogo.http.mime.MIMEPartParser;
import com.cognos.pogo.util.CAMUtils;
import com.ibm.cognos.cm.repositoryService.HTTPHeaders;
import com.ibm.cognos.cm.repositoryService.HeaderHelper;
import com.ibm.cognos.cm.repositoryService.cache.internal.NonClosingOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.GZIPInputStream;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.mail.MessagingException;
import javax.mail.internet.MimeUtility;
import org.apache.commons.io.IOUtils;

public class CachedItem
implements Serializable {
    private static final long serialVersionUID = 5474656643466340146L;
    private ConcurrentHashMap<String, Part> parts = new ConcurrentHashMap();
    private String firstPart = null;
    private SimpleDateFormat formatter = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
    private Map<String, String> cacheHeaders = new HashMap<String, String>();
    private static CAMUtils camUtils = new CAMUtils();
    private boolean encrypt = false;

    public CachedItem(InputStream is, boolean encrypt, boolean expandMHT) throws IOException, MessagingException {
        this.load(is, expandMHT);
        this.formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.encrypt = encrypt;
    }

    private void load(InputStream is, boolean expandMHT) throws IOException, MessagingException {
        HTTPHeaders headers = HeaderHelper.parse(is);
        if (headers.isMHT() && expandMHT) {
            InputStream mhtStream = is;
            if (headers.isCompressed()) {
                mhtStream = new GZIPInputStream(is);
            }
            this.processMHTStream(mhtStream);
        } else {
            this.storePart(headers, is);
        }
    }

    private void processMHTStream(InputStream mhtStream) throws IOException, MessagingException {
        HTTPHeaders headers = HeaderHelper.parse(mhtStream);
        String contentTypeHeaderValue = headers.get("Content-Type");
        MIMEPartParser streamIterator = new MIMEPartParser(mhtStream, MIMEPartParser.getBoundaryFromContentType((String)contentTypeHeaderValue));
        while (streamIterator.hasNext()) {
            InputStream inputStream = (InputStream)streamIterator.next();
            headers = HeaderHelper.parse(inputStream);
            this.storePart(headers, inputStream);
        }
    }

    private String extractPartName(String contentLocationHeaderValue) {
        String partName = null;
        if (contentLocationHeaderValue != null) {
            partName = contentLocationHeaderValue.startsWith("../") ? contentLocationHeaderValue.substring(3) : contentLocationHeaderValue;
        }
        return partName;
    }

    private void storePart(HTTPHeaders headers, InputStream inputStream) throws IOException, MessagingException {
        String encoding;
        headers.removeCacheControlHeader();
        String partName = this.extractPartName(headers.get("Content-Location"));
        if (this.firstPart == null) {
            if (partName == null) {
                partName = "main";
            }
            this.firstPart = partName;
        }
        byte[] buffer = IOUtils.toByteArray((InputStream)((encoding = headers.get("Content-Transfer-Encoding")) != null ? MimeUtility.decode((InputStream)inputStream, (String)encoding) : inputStream));
        this.parts.put(partName == null ? "obj" + System.nanoTime() : partName, new Part(headers, buffer));
    }

    public void setExpiry(long expirationTime) {
        this.cacheHeaders.put("Cache-control", "private");
        this.cacheHeaders.put("Expires", this.formatter.format(expirationTime));
    }

    public String getFirstPartName() {
        return this.firstPart != null ? this.firstPart : "main";
    }

    public boolean hasPart(String partName) {
        if (partName == null || partName.length() == 0) {
            return this.parts.get(this.getFirstPartName()) != null;
        }
        return this.parts.get(partName) != null;
    }

    public InputStream getContentStream() {
        return this.parts.get(this.getFirstPartName()).getContentStream();
    }

    public InputStream getContentStream(String partName) {
        return this.parts.get(partName).getContentStream();
    }

    public HTTPHeaders getHeaders() {
        return this.parts.get(this.getFirstPartName()).getHeaders();
    }

    public HTTPHeaders getHeaders(String partName) {
        return this.parts.get(partName).getHeaders();
    }

    private class Part
    implements Serializable {
        private static final long serialVersionUID = -3794527512881425765L;
        private HTTPHeaders headers = null;
        private transient byte[] buffer = null;

        public Part(HTTPHeaders headers, byte[] buffer) {
            this.headers = headers;
            this.buffer = buffer;
        }

        public InputStream getContentStream() {
            return new ByteArrayInputStream(this.buffer);
        }

        public HTTPHeaders getHeaders() {
            HTTPHeaders hdrs = new HTTPHeaders(CachedItem.this.cacheHeaders);
            hdrs.putAll(this.headers);
            return hdrs;
        }

        private void writeObject(ObjectOutputStream stream) throws IOException, CAMCryptoException {
            stream.defaultWriteObject();
            if (CachedItem.this.encrypt) {
                NonClosingOutputStream ncos = new NonClosingOutputStream(stream);
                CipherOutputStream cos = camUtils.getCamFactory().createEncryptingOutputStream((OutputStream)ncos);
                ObjectOutputStream coos = new ObjectOutputStream(cos);
                coos.writeObject(this.buffer);
                coos.flush();
                coos.close();
            } else {
                stream.writeObject(this.buffer);
            }
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException, CAMCryptoException {
            stream.defaultReadObject();
            if (CachedItem.this.encrypt) {
                CipherInputStream cis = camUtils.getCamFactory().createDecryptingInputStream((InputStream)stream);
                ObjectInputStream cois = new ObjectInputStream(cis);
                this.buffer = (byte[])cois.readObject();
                cois.close();
            } else {
                this.buffer = (byte[])stream.readObject();
            }
        }
    }
}

