/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryService.cache;

import java.util.concurrent.atomic.AtomicInteger;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;

class EhCacheDelegate {
    static final int EVICT_INTERVAL = 100;
    private Ehcache cache;
    private AtomicInteger counter = new AtomicInteger(0);

    EhCacheDelegate(Ehcache cache) {
        this.cache = cache;
    }

    boolean isStatisticsEnabled() {
        return this.cache.isStatisticsEnabled();
    }

    void setStatisticsEnabled(boolean enableStatistics) {
        this.cache.setStatisticsEnabled(enableStatistics);
    }

    String getName() {
        return this.cache.getName();
    }

    String getStatisticsString() {
        return this.cache.getStatistics().toString();
    }

    long calculateInMemorySize() {
        return this.cache.calculateInMemorySize();
    }

    boolean isKeyInCache(Object key) {
        return this.cache.isKeyInCache(key);
    }

    Element get(Object key) {
        return this.cache.get(key);
    }

    void put(Element element) {
        this.cache.put(element);
        int count = this.counter.incrementAndGet();
        if (count % 100 == 0) {
            this.cache.evictExpiredElements();
        }
    }

    void remove(Object key) {
        this.cache.remove(key);
    }

    void removeAll() {
        this.cache.removeAll();
    }

    CacheConfiguration getConfig() {
        return this.cache.getCacheConfiguration();
    }
}

