/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryService.cache;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cmutils.log.LogKitACLBridge;
import com.cognos.cmutils.log.LogKitACLBridgeFactory;
import com.cognos.cmutils.messages.Resource;
import com.ibm.cognos.cm.repositoryService.RepositoryServiceErrors;
import com.ibm.cognos.cm.repositoryService.cache.BaseCache;
import com.ibm.cognos.cm.repositoryService.cache.CacheType;
import com.ibm.cognos.cm.repositoryService.cache.CachedItemFactory;
import net.sf.ehcache.config.CacheConfiguration;

class RepositoryCache
extends BaseCache {
    private static LogKitACLBridge log = LogKitACLBridgeFactory.getLog(RepositoryCache.class);
    private static final int DEFAULT_DISK_SPOOL_BUFFER_SIZE = 100;
    private static final int DEFAULT_TTL = 1200;
    private static final CacheType CACHE_TYPE = CacheType.REPOSITORY;

    RepositoryCache(CachedItemFactory itemFactory) {
        super(itemFactory);
    }

    @Override
    public void updateCacheProperties(ICCLConfiguration config) throws RepositoryException {
        try {
            CacheConfiguration repositoryCacheConfig = this.ehCacheDelegate.getConfig();
            String timeToLiveSeconds = config.getValue("reposCacheObjTTL", true);
            String maxElementsOnDisk = config.getValue("reposNumObjDisk", true);
            String maxElementsInMemeory = config.getValue("reposNumObjMem", true);
            repositoryCacheConfig.setMaxElementsInMemory(Integer.parseInt(maxElementsInMemeory));
            repositoryCacheConfig.setMaxElementsOnDisk(Integer.parseInt(maxElementsOnDisk));
            repositoryCacheConfig.timeToLiveSeconds((long)Integer.parseInt(timeToLiveSeconds));
            this.setMaxCacheDocSize(config);
        }
        catch (CCLConfigurationException e) {
            throw new RepositoryException((Resource.Id)RepositoryServiceErrors.REPS_SERVER.repositoryConfigurationError, (Throwable)e);
        }
        catch (NullPointerException e) {
            throw new RepositoryException((Resource.Id)RepositoryServiceErrors.REPS_SERVER.repositoryConfigurationError);
        }
    }

    @Override
    CacheConfiguration createRepositoryCacheConfiguration() throws RepositoryException {
        try {
            CacheConfiguration repositoryCacheConfig = this.getConfiguration();
            if (repositoryCacheConfig == null) {
                repositoryCacheConfig = new CacheConfiguration();
                repositoryCacheConfig.setName(CACHE_TYPE.toString());
                repositoryCacheConfig.setEternal(false);
                repositoryCacheConfig.setOverflowToDisk(true);
                repositoryCacheConfig.setDiskSpoolBufferSizeMB(100);
                repositoryCacheConfig.setTimeToLiveSeconds(1200L);
                repositoryCacheConfig.setMemoryStoreEvictionPolicy("LRU");
            }
            return repositoryCacheConfig;
        }
        catch (Exception e) {
            throw new RepositoryException((Resource.Id)RepositoryServiceErrors.REPS_SERVER.repositoryConfigurationError, (Throwable)e);
        }
    }

    private CacheConfiguration getConfiguration() {
        CacheConfiguration repositoryCacheConfig = null;
        if (this.ehCacheDelegate != null) {
            repositoryCacheConfig = this.ehCacheDelegate.getConfig();
        }
        return repositoryCacheConfig;
    }

    @Override
    public CacheType getType() {
        return CACHE_TYPE;
    }

    @Override
    LogKitACLBridge log() {
        return log;
    }
}

