/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryService.cache.connection;

import com.cognos.pogo.util.URLEncoderDecoder;
import java.io.UnsupportedEncodingException;

public class CacheID {
    private static final String DIVIDER = "_";
    private static final String URL_ENCODING = "UTF-8";
    private final String nodeID;
    private final String entryID;

    CacheID(String nodeID, String entryID) {
        this.nodeID = nodeID;
        this.entryID = entryID;
    }

    public static CacheID fromURIString(String id) {
        try {
            String decoded = URLEncoderDecoder.decode((String)id, (String)URL_ENCODING);
            int split = decoded.lastIndexOf(DIVIDER);
            if (split != -1) {
                String nodeID = decoded.substring(0, split);
                String entryID = decoded.substring(split + 1);
                if (nodeID.length() > 0 && entryID.length() > 0) {
                    return new CacheID(nodeID, entryID);
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
        throw new IllegalArgumentException(id);
    }

    public String getNodeID() {
        return this.nodeID;
    }

    public String getEntryID() {
        return this.entryID;
    }

    public String toURIString() {
        try {
            return URLEncoderDecoder.encode((String)this.toString(), (String)URL_ENCODING, (boolean)false, (boolean)false);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String toString() {
        return this.nodeID + DIVIDER + this.entryID;
    }
}

