/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryService.cache.connection;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

class SizeLimitedInputStream
extends FilterInputStream {
    private final long limit;
    private long sofar = 0L;

    public SizeLimitedInputStream(InputStream in, long limit) {
        super(in);
        this.limit = limit;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = super.read(b, off, len);
        this.sofar += (long)read;
        if (this.sofar > this.limit) {
            throw new IllegalArgumentException();
        }
        return read;
    }
}

