/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryService.cache.internal;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.pogo.pdk.Configuration;
import com.ibm.cognos.cm.repositoryService.cache.internal.DispatcherMap;

public class CacheServiceConfiguration {
    private Configuration config;
    private boolean encyptCacheFiles;
    private DispatcherMap dispatchers = new DispatcherMap();

    public CacheServiceConfiguration(Configuration config) {
        this.processConfiguration(config);
    }

    public void processConfiguration(Configuration config) {
        this.config = config;
        this.encyptCacheFiles = Boolean.parseBoolean(config.getValue("encryptTemporaryFiles"));
        this.dispatchers.setupDispatcherList(config);
    }

    public String getCMRestURL() {
        String cm = null;
        try {
            StringBuilder sb = new StringBuilder();
            cm = this.config.getICCLConfiguration().getValue("contentManager", true);
            if (cm.length() > 0) {
                sb.append(cm.substring(0, cm.indexOf("/servlet")));
                sb.append("/cm/1.0/objects");
                cm = sb.toString();
            } else {
                cm = null;
            }
        }
        catch (CCLConfigurationException cCLConfigurationException) {
            // empty catch block
        }
        return cm;
    }

    public boolean encryptCacheFiles() {
        return this.encyptCacheFiles;
    }

    public DispatcherMap getDispatchers() {
        return this.dispatchers;
    }
}

