/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryService.connection;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.cm.client.cmapi.HttpCommand;
import com.cognos.cm.client.cmapi.HttpCommandFactory;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.repositoryPluginFramework.AccessControlHelper;
import com.cognos.cm.repositoryPluginFramework.identity.IdentityProvider;
import com.cognos.cmutils.messages.Resource;
import com.cognos.pogo.pdk.MessageContext;
import com.ibm.cognos.cm.repositoryService.RepositoryServiceErrors;
import com.ibm.cognos.cm.repositoryService.authorization.BaseAccessControl;
import com.ibm.cognos.cm.repositoryService.messagecontext.MessageContextHelper;
import com.ibm.json.java.JSONArray;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CMAccessControl
extends BaseAccessControl {
    private static Log log = LogFactory.getLog(CMAccessControl.class);
    private final String objectID;
    private final HttpCommandFactory commandFactory;

    public CMAccessControl(String objectID, MessageContextHelper messageContextHelper, AccessControlHelper acmHelper, IdentityProvider identityProvider, HttpCommandFactory commandFactory) {
        super(acmHelper, messageContextHelper, identityProvider);
        this.objectID = objectID;
        this.commandFactory = commandFactory;
    }

    @Override
    public boolean isAccessGranted(String passportID, String accessRequired, MessageContext context) throws RepositoryException {
        HttpCommand command = this.commandFactory.getCommand(context, "/1.0/objects/" + this.objectID + "/permissions");
        try {
            int httpCode = command.execute();
            if (401 == httpCode) {
                throw new RepositoryException((Resource.Id)RepositoryServiceErrors.REPS_REP.repositoryMissingPassport);
            }
            if (200 != httpCode) {
                return false;
            }
            String permissions = command.getResponseBody();
            JSONArray objArray = JSONArray.parse((String)permissions);
            for (String item : objArray) {
                if (!accessRequired.equals(item)) continue;
                return true;
            }
            return false;
        }
        catch (IOException e) {
            this.logException(e);
            return false;
        }
        catch (CAMCryptoException e) {
            this.logException((Exception)((Object)e));
            return false;
        }
    }

    private void logException(Exception e) {
        String message = e.getMessage();
        log.error((Object)message, (Throwable)e);
    }
}

