/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryService.connection;

import com.cognos.cm.repositoryPluginAPI.IRepositoryHttpClientFactory;
import com.cognos.cm.repositoryPluginAPI.IRepositoryUserAgentFactory;
import com.cognos.cm.repositoryPluginAPI.RepositoryConnection;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.repositoryPluginFramework.IPluginResourceLoader;
import com.cognos.cm.repositoryPluginFramework.IRepositoryConnectionString;
import com.cognos.cm.repositoryPluginFramework.IRepositoryPluginManager;
import com.cognos.cm.repositoryPluginFramework.RepositoryConnectionString;
import com.cognos.pogo.pdk.MessageContext;
import com.ibm.cognos.cm.repositoryService.connection.CMConnectionDataProvider;
import com.ibm.cognos.cm.repositoryService.connection.ConnectionData;
import com.ibm.cognos.cm.repositoryService.connection.ConnectionDataCache;
import com.ibm.cognos.cm.repositoryService.connection.RepositoryConnectionProvider;
import com.ibm.cognos.cm.repositoryService.messagecontext.MessageContextHelper;
import java.util.Properties;
import javax.mail.internet.InternetHeaders;
import javax.servlet.http.Cookie;

public class CMConnectionProvider
implements RepositoryConnectionProvider {
    private static final String[] PASSTHROUGH_HTTP_HEADERS = new String[]{"X-CA-Authorization"};
    private final ConnectionDataCache connectionDataCache;
    private final IRepositoryHttpClientFactory repositoryHttpClientFactory;
    private final MessageContextHelper messageContextHelper;
    private final IRepositoryPluginManager pluginManager;
    private final CMConnectionDataProvider connectionDataProvider;
    private final String cmRestURI;

    CMConnectionProvider(IRepositoryHttpClientFactory repositoryHttpClientFactory, MessageContextHelper messageContextHelper, IRepositoryPluginManager pluginManager, CMConnectionDataProvider connectionDataProvider, String cmRestURI) {
        this.repositoryHttpClientFactory = repositoryHttpClientFactory;
        this.messageContextHelper = messageContextHelper;
        this.pluginManager = pluginManager;
        this.connectionDataProvider = connectionDataProvider;
        this.connectionDataCache = ConnectionDataCache.getSharedInstance();
        this.cmRestURI = cmRestURI;
    }

    @Override
    public RepositoryConnection getConnection(String dataSourceID, MessageContext mc, IPluginResourceLoader resourceLoader) throws RepositoryException {
        ConnectionData connectionData = null;
        if ("cm".equalsIgnoreCase(dataSourceID)) {
            String connectionString = "^User ID:^?Password:;LOCAL;RP-CMIS-CM;URL=" + this.cmRestURI + "/1.0/objects/;DRIVER_NAME=com.ibm.cognos.cm.cmrepository.CMRepositoryPlugin";
            connectionData = new ConnectionData();
            connectionData.setConnectionString(connectionString);
            connectionData.setConnectionTenantID("");
            connectionData.setUserTenantID("");
            Cookie passportCookie = this.messageContextHelper.getCamPassportCookie(mc);
            if (passportCookie != null) {
                connectionData.setPassword(passportCookie.getValue());
            }
        } else {
            connectionData = this.getConnectionData(dataSourceID, mc);
        }
        RepositoryConnection connection = this.getRepositoryConnection(connectionData, resourceLoader, mc);
        return connection;
    }

    private ConnectionData getConnectionData(String dataSourceID, MessageContext mc) throws RepositoryException {
        String tenantID;
        String passportID = this.messageContextHelper.getPassportIDFromCookies(mc);
        ConnectionData connectionData = this.connectionDataCache.get(passportID, tenantID = this.connectionDataProvider.getUserTenantID(), dataSourceID);
        if (connectionData == null && (connectionData = this.connectionDataProvider.getConnectionData(dataSourceID)) != null) {
            this.connectionDataCache.put(passportID, tenantID, dataSourceID, connectionData);
        }
        return connectionData;
    }

    private RepositoryConnection getRepositoryConnection(ConnectionData connectionData, IPluginResourceLoader repositoryServiceResourceLoader, MessageContext mc) throws RepositoryException {
        String connectionStringValue = connectionData.getConnectionString();
        RepositoryConnectionString connectionString = new RepositoryConnectionString(connectionStringValue);
        Properties props = new Properties();
        String userName = connectionData.getUsername();
        String password = connectionData.getPassword();
        if (userName != null) {
            props.put("user", userName);
        }
        if (password != null) {
            props.put("password", password);
        }
        props.put("connectionTenantID", connectionData.getConnectionTenantID());
        props.put("userTenantID", connectionData.getUserTenantID());
        props.put("CONSUMER_NAME", "REPS");
        props.put("connectionTenantID", connectionData.getConnectionTenantID());
        this.setPropertiesFromHttpHeaders(mc, props);
        RepositoryConnection connection = this.pluginManager.getConnection((IRepositoryUserAgentFactory)this.repositoryHttpClientFactory, (IRepositoryConnectionString)connectionString, props, repositoryServiceResourceLoader);
        return connection;
    }

    public CMConnectionDataProvider getConnectionDataProvider() {
        return this.connectionDataProvider;
    }

    private void setPropertiesFromHttpHeaders(MessageContext mc, Properties properties) {
        if (mc == null || mc.getProperty("request.headers") == null) {
            return;
        }
        InternetHeaders headers = (InternetHeaders)mc.getProperty("request.headers");
        for (String header : PASSTHROUGH_HTTP_HEADERS) {
            String value = headers.getHeader(header, null);
            if (value == null) continue;
            properties.put("http." + header, value);
        }
    }
}

