/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryService.connection;

import com.ibm.cognos.cm.repositoryService.connection.ConnectionData;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.map.ReferenceMap;

public class ConnectionDataCache {
    private static final ConnectionDataCache INSTANCE = new ConnectionDataCache();
    private final ReferenceMap referenceMap = new ReferenceMap(0, 1);

    ConnectionDataCache() {
    }

    public ConnectionData put(String passportID, String tenantID, String dataSourceID, ConnectionData connectionData) {
        String key = this.getKey(passportID, tenantID);
        ConcurrentHashMap<String, ConnectionData> userConnectionMap = this.getUserConnectionMap(key);
        return userConnectionMap.put(dataSourceID, connectionData);
    }

    public ConnectionData get(String passportID, String tenantID, String dataSourceID) {
        String key = this.getKey(passportID, tenantID);
        ConcurrentHashMap<String, ConnectionData> userConnectionMap = this.getUserConnectionMap(key);
        return userConnectionMap.get(dataSourceID);
    }

    private String getKey(String passportID, String tenantID) {
        return passportID + tenantID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConcurrentHashMap<String, ConnectionData> getUserConnectionMap(String passportID) {
        ConcurrentHashMap userConnectionMap = (ConcurrentHashMap)this.referenceMap.get((Object)passportID);
        if (userConnectionMap == null) {
            ReferenceMap referenceMap = this.referenceMap;
            synchronized (referenceMap) {
                userConnectionMap = (ConcurrentHashMap)this.referenceMap.get((Object)passportID);
                if (userConnectionMap == null) {
                    userConnectionMap = new ConcurrentHashMap();
                    this.referenceMap.put((Object)passportID, userConnectionMap);
                }
            }
        }
        return userConnectionMap;
    }

    public static ConnectionDataCache getSharedInstance() {
        return INSTANCE;
    }

    public synchronized void clear() {
        this.referenceMap.clear();
    }
}

