/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryService.connection.cmclient;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.cm.client.cmapi.HttpCommand;
import com.cognos.cm.client.cmapi.HttpCommandFactory;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.repositoryPluginFramework.RepositoryPluginErrors;
import com.cognos.cmutils.http.HttpMethodFactory;
import com.cognos.cmutils.messages.Message;
import com.cognos.cmutils.messages.Resource;
import com.cognos.pogo.pdk.MessageContext;
import com.ibm.cognos.cm.repositoryService.RepositoryServiceErrors;
import com.ibm.cognos.cm.repositoryService.connection.CMConnectionDataProvider;
import com.ibm.cognos.cm.repositoryService.connection.ConnectionData;
import com.ibm.cognos.cm.repositoryService.rest.resource.ResourceException;
import com.ibm.cognos.cm.repositoryService.service.CryptoHelper;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.util.Locale;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CMConnectionDataProviderCMClient
implements CMConnectionDataProvider {
    private static final Log log = LogFactory.getLog(CMConnectionDataProviderCMClient.class);
    private static final String TENANT_REQUEST = "/1.0/objects/~~/tenantID";
    private final CryptoHelper cryptoHelper;
    private final HttpCommandFactory commandFactory;
    private final MessageContext mc;
    private String dataSourceID;

    public CMConnectionDataProviderCMClient(CryptoHelper cryptoHelper, HttpMethodFactory httpMethodFactory, MessageContext mc) {
        this.cryptoHelper = cryptoHelper;
        this.commandFactory = new HttpCommandFactory(httpMethodFactory);
        this.mc = mc;
    }

    @Override
    public ConnectionData getConnectionData(String dataSourceID) throws RepositoryException {
        this.dataSourceID = dataSourceID;
        try {
            this.checkCapabilities();
            ConnectionData data = this.callDataSourceSignon();
            return data;
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (ResourceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryException((Resource.Id)RepositoryPluginErrors.REP_API.repositoryError, (Throwable)e);
        }
    }

    private void checkCapabilities() throws RepositoryException, IOException, CAMCryptoException {
        if (!this.hasRequiredUserCapability("canViewContentInRepository")) {
            if (log.isErrorEnabled()) {
                log.error((Object)new Message((Resource.Id)RepositoryServiceErrors.REPS_CM.repositoryNoCapability).format(Locale.getDefault()));
            }
            throw new ResourceException(404, new Message((Resource.Id)RepositoryServiceErrors.REPS_CM.repositoryObjectNotFound));
        }
    }

    private boolean hasRequiredUserCapability(String capability) throws RepositoryException, IOException, CAMCryptoException {
        HttpCommand command = this.commandFactory.getCommand(this.mc, "/1.0/objects/~~/userCapabilities");
        int httpCode = command.execute();
        if (401 == httpCode) {
            throw this.newUnauthorizedResourceException();
        }
        if (200 != httpCode) {
            return false;
        }
        String httpResponse = command.getResponseBody();
        JSONArray objArray = JSONArray.parse((String)httpResponse);
        for (String item : objArray) {
            if (!capability.equals(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getUserTenantID() throws RepositoryException {
        try {
            HttpCommand command = this.commandFactory.getCommand(this.mc, TENANT_REQUEST);
            int responseCode = command.execute();
            if (200 == responseCode) {
                JSONArray response = JSONArray.parse((String)command.getResponseBody());
                if (response.size() > 0) {
                    return response.get(0).toString();
                }
            } else if (401 == responseCode) {
                throw this.newUnauthorizedResourceException();
            }
            Message msg = new Message((Resource.Id)RepositoryServiceErrors.REPS_CM.repositoryFailCMQuery).param("responseCode", String.valueOf(responseCode)).param("property", "tenantID");
            throw new RepositoryException(msg);
        }
        catch (IOException e) {
            throw new RepositoryException((Resource.Id)RepositoryPluginErrors.REP_API.repositoryError, (Throwable)e);
        }
        catch (CAMCryptoException e) {
            throw new RepositoryException((Resource.Id)RepositoryPluginErrors.REP_API.repositoryError, (Throwable)e);
        }
    }

    @Override
    public String getSearchPath(String storeID) throws RepositoryException {
        try {
            String requestURI = "/1.0/objects/" + storeID + "/searchPath";
            HttpCommand command = this.commandFactory.getCommand(this.mc, requestURI);
            int responseCode = command.execute();
            if (200 == responseCode) {
                String searchPath = command.getResponseBody();
                return searchPath;
            }
            if (401 == responseCode) {
                throw this.newUnauthorizedResourceException();
            }
            Message msg = new Message((Resource.Id)RepositoryServiceErrors.REPS_CM.repositoryFailCMQuery).param("responseCode", String.valueOf(responseCode)).param("property", "searchPath");
            throw new RepositoryException(msg);
        }
        catch (IOException e) {
            throw new RepositoryException((Resource.Id)RepositoryPluginErrors.REP_API.repositoryError, (Throwable)e);
        }
        catch (CAMCryptoException e) {
            throw new RepositoryException((Resource.Id)RepositoryPluginErrors.REP_API.repositoryError, (Throwable)e);
        }
    }

    private ConnectionData callDataSourceSignon() throws Exception {
        JSONArray jsonArray = this.httpDataSourceSignon(this.dataSourceID);
        ConnectionData data = this.handleResponse(jsonArray);
        data.setUserTenantID(this.getUserTenantID());
        return data;
    }

    private ConnectionData handleResponse(JSONArray jsonArray) throws Exception {
        JSONObject connection = null;
        JSONObject signon = null;
        for (JSONObject obj : jsonArray) {
            String objectClass = this.getPropAsString(obj, "objectClass");
            if ("dataSourceConnection".equals(objectClass)) {
                if (connection == null) {
                    connection = obj;
                    continue;
                }
                Message msg = new Message((Resource.Id)RepositoryServiceErrors.REPS_CM.repositoryAmbiguousConnection);
                msg.param("id", this.dataSourceID);
                throw new RepositoryException(msg);
            }
            if (!"dataSourceSignon".equals(objectClass)) continue;
            signon = obj;
        }
        return this.getConnectionData(connection, signon);
    }

    private ConnectionData getConnectionData(JSONObject connection, JSONObject signon) throws Exception {
        if (connection == null) {
            Message msg = new Message((Resource.Id)RepositoryServiceErrors.REPS_CM.repositoryDataSourceUnavailable);
            throw new RepositoryException(msg);
        }
        ConnectionData data = new ConnectionData();
        data.setConnectionString(this.getPropAsString(connection, "connectionString"));
        data.setConnectionTenantID(this.getPropAsString(connection, "tenantID"));
        if (signon != null) {
            String credentials = this.getPropAsString(signon, "credentials");
            String[] credsPair = this.cryptoHelper.getCredentialsHelper().createCredentialsPropertiesFromPropertyValue(credentials);
            data.setUsername(credsPair[0]);
            data.setPassword(credsPair[1]);
        }
        return data;
    }

    private String getPropAsString(JSONObject obj, String propName) {
        Object value = obj.get((Object)propName);
        return value == null ? null : value.toString();
    }

    private JSONArray httpDataSourceSignon(String dataSourceID) throws RepositoryException, IOException, CAMCryptoException {
        HttpCommand command = this.commandFactory.getCommand(this.mc, "/1.0/functions/defaultRepositoryConnection");
        NameValuePair[] nvPairs = new NameValuePair[]{new NameValuePair("id", dataSourceID), new NameValuePair("property", "objectClass"), new NameValuePair("property", "connectionString"), new NameValuePair("property", "credentials"), new NameValuePair("property", "tenantID")};
        command.setQueryString(nvPairs);
        int httpCode = command.execute();
        if (httpCode == 401) {
            throw this.newUnauthorizedResourceException();
        }
        if (httpCode != 200) {
            throw this.newHttpException(command);
        }
        String httpResponse = command.getResponseBody();
        if (log.isDebugEnabled()) {
            log.debug((Object)(command.getURL() + " returned: " + httpResponse));
        }
        return JSONArray.parse((String)httpResponse);
    }

    private RepositoryException newHttpException(HttpCommand command) {
        Message msg = new Message((Resource.Id)RepositoryServiceErrors.REPS_CM.repositoryDataSourceUnavailable);
        if (log.isErrorEnabled()) {
            log.error((Object)msg.format(Locale.getDefault()));
            log.error((Object)(command.getURL() + " returned " + command.getStatusCode() + ": " + command.getStatusLine()));
        }
        return new RepositoryException(msg);
    }

    private ResourceException newUnauthorizedResourceException() {
        return new ResourceException(401, new Message((Resource.Id)RepositoryServiceErrors.REPS_REP.repositoryMissingPassport));
    }
}

