/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryService.errorhandler;

import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cmutils.messages.Message;
import com.cognos.cmutils.messages.Resource;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.util.StringUtils;
import com.ibm.cognos.cm.repositoryService.errorhandler.RepositoryErrorHandler;
import com.ibm.cognos.cm.repositoryService.errorhandler.RepositoryServiceFault;
import com.ibm.cognos.cm.repositoryService.rest.resource.ResourceException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Locale;

public class BasicRepositoryErrorHandler
implements RepositoryErrorHandler {
    @Override
    public void respond(MessageContext context, ResourceException e) {
        ByteArrayInputStream is;
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            OutputStreamWriter osWriter = new OutputStreamWriter((OutputStream)stream, "UTF-8");
            osWriter.write("Content-Type");
            osWriter.write("text/plain; charset=UTF-8 \r\n\r\n");
            String error = e.message().format((Locale)context.getProperty("locale"), "\n");
            osWriter.write(error);
            osWriter.flush();
            is = new ByteArrayInputStream(stream.toByteArray());
            stream.close();
            osWriter.close();
        }
        catch (IOException e1) {
            is = new ByteArrayInputStream(new byte[0]);
        }
        ArrayList<ByteArrayInputStream> attachmentList = new ArrayList<ByteArrayInputStream>();
        attachmentList.add(is);
        BIBusEnvelope bus = (BIBusEnvelope)context.getProperty("request.envelope");
        context.setResponseName("response");
        context.setProperty("response.envelope", (Object)bus);
        context.setProperty("response.status_code", (Object)Integer.toString(e.getStatusCode()));
        context.setProperty("response.boundary", (Object)StringUtils.getUniqueValue());
        context.setProperty("response.attachments", attachmentList.iterator());
    }

    @Override
    public void respond(MessageContext context, RepositoryException e) {
        RepositoryServiceFault fault = new RepositoryServiceFault(e);
        this.assignFaultToMessageContext(fault, context);
    }

    @Override
    public void respond(MessageContext context, Resource.Id errorCode, Message message) {
        RepositoryServiceFault fault = new RepositoryServiceFault(errorCode, message);
        this.assignFaultToMessageContext(fault, context);
    }

    @Override
    public void respond(MessageContext context, Message message, Exception e) {
        RepositoryServiceFault fault = new RepositoryServiceFault(message, e);
        this.assignFaultToMessageContext(fault, context);
    }

    private void assignFaultToMessageContext(RepositoryServiceFault fault, MessageContext context) {
        this.overrideHttpStatusIfNeeded(fault, context);
        context.setFault((Fault)fault);
    }

    private void overrideHttpStatusIfNeeded(RepositoryServiceFault fault, MessageContext context) {
        if (this.hasNoHttpStatus(context)) {
            fault.setHTTPStatusOverride(500);
        }
    }

    private boolean hasNoHttpStatus(MessageContext context) {
        return context.getProperty("response.status_code") == null;
    }
}

