/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryService.jmx;

import com.cognos.pogo.monitoring.CounterMbeanInterface;
import com.ibm.cognos.cm.repositoryService.authorization.AccessControlCacheManager;
import com.ibm.cognos.cm.repositoryService.cache.Cache;
import com.ibm.cognos.cm.repositoryService.connection.ConnectionDataCache;
import com.ibm.cognos.cm.repositoryService.jmx.CacheControlMBean;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class CacheControl
implements CacheControlMBean,
CounterMbeanInterface {
    static final String CONTROL_NAME = "CacheControl";
    private final Set<Cache> cacheList = Collections.synchronizedSet(new HashSet());
    private static final CacheControl INSTANCE = new CacheControl();

    private CacheControl() {
    }

    public void addCache(Cache cache) {
        this.cacheList.add(cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache() {
        Set<Cache> set = this.cacheList;
        synchronized (set) {
            for (Cache cache : this.cacheList) {
                cache.clearAll();
            }
        }
        AccessControlCacheManager.clearAll();
        ConnectionDataCache.getSharedInstance().clear();
    }

    @Override
    public String getName() {
        return CONTROL_NAME;
    }

    @Override
    public boolean getIsCacheEnabled() {
        return !this.cacheList.isEmpty();
    }

    public void clearCacheListForTesting() {
        this.cacheList.clear();
    }

    public static CacheControl getInstance() {
        return INSTANCE;
    }
}

