/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryService.messagecontext;

import com.cognos.ccl4j.bibus.CAMCookie;
import com.cognos.ccl4j.bibus.CAMCookieFactory;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cmutils.messages.Resource;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.ibm.cognos.cm.repositoryService.RepositoryServiceErrors;
import com.ibm.cognos.cm.repositoryService.messagecontext.MessageContextHelper;
import javax.servlet.http.Cookie;
import org.dom4j.Element;

public class BasicMessageContextHelper
implements MessageContextHelper {
    BasicMessageContextHelper() {
    }

    @Override
    public String getPassportIDFromCookies(MessageContext mc) {
        String passportIDCookieValue = this.getCamPassport(mc);
        if (passportIDCookieValue == null) {
            throw new UnsupportedOperationException("There is no support from obtaining the cam cookie from the URL");
        }
        String camPassportID = BasicMessageContextHelper.getCAMPassportID(passportIDCookieValue);
        return camPassportID;
    }

    @Override
    public String getCamPassport(MessageContext mc) {
        Cookie passportCookie = this.getCamPassportCookie(mc);
        return passportCookie == null ? null : passportCookie.getValue();
    }

    @Override
    public Cookie getCamPassportCookie(MessageContext mc) {
        String value;
        if (mc != null && (value = (String)BasicMessageContextHelper.getProperty(mc, "auth.passportid")) != null) {
            return new Cookie("cam_passport", value);
        }
        return null;
    }

    @Override
    public Element getRequestEnvelopeHeader(MessageContext mc) throws RepositoryException {
        Element envelopeHeader;
        BIBusEnvelope originalEnvelope = (BIBusEnvelope)BasicMessageContextHelper.getProperty(mc, "request.envelope");
        try {
            envelopeHeader = originalEnvelope.getAsDocument().getRootElement().element("Header");
        }
        catch (NullPointerException e) {
            envelopeHeader = null;
        }
        if (envelopeHeader == null) {
            throw new RepositoryException((Resource.Id)RepositoryServiceErrors.REPS_CM.invalidSOAPRequest);
        }
        return envelopeHeader;
    }

    private static String getCAMPassportID(String cookieValue) {
        CAMCookie aCookie = CAMCookieFactory.createCAMCookie((String)cookieValue);
        return aCookie.getPassportID();
    }

    public static MessageContextHelper getInstance() {
        return new BasicMessageContextHelper();
    }

    @Override
    public String getRequestContext(MessageContext mc) {
        BIBusEnvelope originalEnv = (BIBusEnvelope)BasicMessageContextHelper.getProperty(mc, "request.envelope");
        String requestID = originalEnv.getRequestContext();
        return requestID;
    }

    @Override
    public String getSessionContext(MessageContext mc) {
        BIBusEnvelope originalEnv = (BIBusEnvelope)BasicMessageContextHelper.getProperty(mc, "request.envelope");
        String sessionID = originalEnv.getSessionContext();
        return sessionID;
    }

    private static <T> T getProperty(MessageContext mc, String name) {
        return (T)mc.getProperty(name);
    }
}

