/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryService.query;

import com.cognos.cm.repositoryPluginAPI.IQueryParameters;
import com.cognos.cm.repositoryPluginAPI.IQueryResult;
import com.cognos.cm.repositoryPluginAPI.RepositoryConnection;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.ibm.cognos.cm.repositoryService.query.RepositoryQuery;
import com.ibm.cognos.cm.repositoryService.query.RepositoryServiceQueryParameters;
import com.ibm.cognos.cm.repositoryService.rest.resource.URIResource;
import java.util.Arrays;
import java.util.Properties;

abstract class BaseQuery
implements RepositoryQuery {
    static final String DEFAULT_LIST_SEPARATOR = ",";
    static final Properties DEFAULT_OPTIONS = new Properties();
    private final RepositoryServiceQueryParameters queryParameters;
    final URIResource requestedResource;

    BaseQuery(URIResource requestedResource) {
        this(requestedResource, new RepositoryServiceQueryParameters());
    }

    BaseQuery(URIResource requestedResource, RepositoryServiceQueryParameters queryParameters) {
        this.queryParameters = queryParameters;
        this.requestedResource = requestedResource;
    }

    abstract void prepareQueryParameters();

    abstract String getQueryName();

    void addParameter(String parameterName, Object value) {
        if (parameterName != null && value != null) {
            this.queryParameters.add(parameterName, value);
        }
    }

    void addIntegerParameter(String parameterName, String stringValue, Integer defaultValue) {
        Integer value = defaultValue;
        if (stringValue != null) {
            value = Integer.valueOf(stringValue);
        }
        this.addParameter(parameterName, value);
    }

    void addStringParameter(String parameterName, String stringValue, String defaultValue) {
        String value = stringValue;
        if (value == null) {
            value = defaultValue;
        }
        this.addParameter(parameterName, value);
    }

    void addStringListParameter(String parameterName, String csvStringValue) {
        if (csvStringValue != null) {
            String[] valuesArray = csvStringValue.split(DEFAULT_LIST_SEPARATOR);
            this.addParameter(parameterName, Arrays.asList(valuesArray));
        }
    }

    @Override
    public IQueryResult execute(RepositoryConnection connection) throws RepositoryException {
        this.prepareQueryParameters();
        return connection.queryObjects(this.getQueryName(), (IQueryParameters)this.queryParameters, DEFAULT_OPTIONS);
    }
}

