/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryService.query;

import com.cognos.cm.repositoryPluginAPI.IQueryResult;
import com.cognos.cm.repositoryPluginAPI.IQueryResultObjects;
import com.cognos.cm.repositoryPluginAPI.RepositoryConnection;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.repositoryPluginFramework.QueryResult;
import com.cognos.cm.repositoryPluginFramework.QueryResultObjects;
import com.cognos.cmutils.messages.Message;
import com.cognos.cmutils.messages.Resource;
import com.cognos.pogo.pdk.MessageContext;
import com.ibm.cognos.cm.repositoryService.HTTPHeaders;
import com.ibm.cognos.cm.repositoryService.RepositoryServiceErrors;
import com.ibm.cognos.cm.repositoryService.authorization.AuthorizationAdapter;
import com.ibm.cognos.cm.repositoryService.cache.Cache;
import com.ibm.cognos.cm.repositoryService.cache.CachedItem;
import com.ibm.cognos.cm.repositoryService.query.RepositoryQuery;
import com.ibm.cognos.cm.repositoryService.rest.resource.ResourceException;
import com.ibm.cognos.cm.repositoryService.rest.resource.ServiceResource;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import net.sf.ehcache.Element;

public class CacheQuery
implements RepositoryQuery {
    public static final String ETAG_VERSION = "version=";
    public static final String ETAG = "ETag";
    private ServiceResource serviceResource;
    private RepositoryQuery query;
    private MessageContext messageContext;
    private Cache cache;
    private AuthorizationAdapter authorizationAdapter;

    public CacheQuery(ServiceResource serviceResource, RepositoryQuery query, MessageContext messageContext, Cache cache, AuthorizationAdapter authorizationAdapter) {
        this.serviceResource = serviceResource;
        this.query = query;
        this.messageContext = messageContext;
        this.cache = cache;
        this.authorizationAdapter = authorizationAdapter;
    }

    @Override
    public IQueryResult execute(RepositoryConnection connection) throws RepositoryException {
        IQueryResult queryResult = this.queryCache(connection);
        if (queryResult == null) {
            if (!connection.doesTestPermissions()) {
                this.verifyAccessGranted(connection);
            }
            queryResult = this.query.execute(connection);
        }
        return queryResult;
    }

    private boolean cachedVersionExpired() throws ResourceException {
        boolean expired = false;
        String versionParam = this.serviceResource.getParameterValue("VERSION");
        if (versionParam != null && !versionParam.isEmpty()) {
            try {
                int version = Integer.parseInt(versionParam);
                int etagVersion = this.getEtagVersion();
                if (version < etagVersion) {
                    throw new ResourceException(404, new Message((Resource.Id)RepositoryServiceErrors.REPS_CM.repositoryObjectNotFound));
                }
                expired = version > etagVersion;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return expired;
    }

    private boolean verifyAccessGranted(RepositoryConnection connection) throws RepositoryException {
        boolean isAccessGranted = this.authorizationAdapter.isGrantedAccess(this.serviceResource.getAuthorizationResourceID(), "read", this.messageContext, connection);
        if (this.messageContext.isFaulted() || !isAccessGranted) {
            throw new ResourceException(404, new Message((Resource.Id)RepositoryServiceErrors.REPS_CM.repositoryObjectNotFound));
        }
        return isAccessGranted;
    }

    private IQueryResult queryCache(RepositoryConnection connection) throws RepositoryException {
        QueryResult queryResult = null;
        if (this.isCached()) {
            if (this.cachedVersionExpired()) {
                this.cache.remove(this.serviceResource.getCacheID());
                return null;
            }
            this.verifyAccessGranted(connection);
            QueryResultObjects objects = new QueryResultObjects(null){

                public int size() {
                    return 1;
                }

                public boolean next() {
                    return true;
                }

                public Object getPropertyValue(String propertyName) {
                    if ("contentStream".equals(propertyName)) {
                        return new ByteArrayInputStream(new byte[0]);
                    }
                    if ("headers".equals(propertyName)) {
                        return this.getCachedHeader();
                    }
                    return null;
                }

                private Object getCachedHeader() {
                    Element element = CacheQuery.this.cache.get(CacheQuery.this.serviceResource.getCacheID());
                    if (element != null) {
                        CachedItem item = (CachedItem)element.getValue();
                        return item.getHeaders();
                    }
                    return new HashMap();
                }
            };
            queryResult = new QueryResult((IQueryResultObjects)objects, false);
        }
        return queryResult;
    }

    public boolean isCached() {
        return this.cache != null && this.cache.get(this.serviceResource.getCacheID()) != null;
    }

    private int getEtagVersion() {
        int versionNumber = -1;
        Element element = this.cache.get(this.serviceResource.getCacheID());
        if (element != null) {
            boolean hasEtagHeader;
            CachedItem item = (CachedItem)element.getValue();
            HTTPHeaders headers = item != null ? item.getHeaders() : null;
            boolean bl = hasEtagHeader = headers != null && headers.containsKey(ETAG);
            if (hasEtagHeader) {
                String etag = headers.get(ETAG);
                int index = etag != null ? etag.trim().indexOf(ETAG_VERSION) : -1;
                try {
                    versionNumber = index != -1 ? Integer.parseInt(etag.substring(index + ETAG_VERSION.length())) : -1;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return versionNumber;
    }
}

