/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryService.query;

import com.cognos.cm.repositoryPluginAPI.IQueryParameters;
import com.cognos.cm.repositoryPluginAPI.IQueryResult;
import com.cognos.cm.repositoryPluginAPI.RepositoryConnection;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.ibm.cognos.cm.repositoryService.query.RepositoryQuery;
import com.ibm.cognos.cm.repositoryService.query.RepositoryServiceQueryParameters;
import java.util.Properties;

public class GetOutputContent
implements RepositoryQuery {
    private final String documentID;
    private final String fileclass;
    private final String filename;
    private final RepositoryServiceQueryParameters parameters;

    public GetOutputContent(String documentID, String fileclass, String filename) {
        this(documentID, fileclass, filename, new RepositoryServiceQueryParameters());
    }

    public GetOutputContent(String documentID, String fileclass, String filename, RepositoryServiceQueryParameters parameters) {
        this.documentID = documentID;
        this.fileclass = fileclass;
        this.filename = filename;
        this.parameters = parameters;
    }

    @Override
    public IQueryResult execute(RepositoryConnection connection) throws RepositoryException {
        this.parameters.add("outputObjectID", this.documentID);
        Properties queryOptions = new Properties();
        IQueryResult result = null;
        String queryName = this.getQueryName();
        if (!this.isQueryOutput()) {
            this.parameters.add("outputFileName", this.filename);
            this.parameters.add("outputFileClass", this.fileclass);
        }
        result = connection.queryObjects(queryName, (IQueryParameters)this.parameters, queryOptions);
        return result;
    }

    private String getQueryName() {
        if (this.isQueryOutput()) {
            return "getOutputContent";
        }
        return "getOutputFileContent";
    }

    private boolean isQueryOutput() {
        return this.fileclass == null || this.filename == null;
    }
}

