/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryService.query;

import com.cognos.cm.repositoryPluginAPI.DataDescriptorProperty;
import com.cognos.cm.repositoryPluginAPI.IDataDescriptor;
import com.cognos.cm.repositoryPluginAPI.IDataDescriptorProperty;
import com.cognos.cm.repositoryPluginAPI.IQueryResult;
import com.cognos.cm.repositoryPluginAPI.IQueryResultObjects;
import com.cognos.cm.repositoryPluginAPI.RepositoryConnection;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.repositoryPluginFramework.DataDescriptor;
import com.cognos.cm.repositoryPluginFramework.QueryResult;
import com.cognos.cm.repositoryPluginFramework.QueryResultObjects;
import com.cognos.cmutils.messages.Message;
import com.cognos.cmutils.messages.Resource;
import com.cognos.pogo.http.mime.MIMEPartParser;
import com.cognos.pogo.pdk.MessageContext;
import com.ibm.cognos.cm.repositoryService.RepositoryServiceErrors;
import com.ibm.cognos.cm.repositoryService.cache.connection.CacheID;
import com.ibm.cognos.cm.repositoryService.cache.connection.CacheSaveDataResult;
import com.ibm.cognos.cm.repositoryService.query.RepositoryQuery;
import com.ibm.cognos.cm.repositoryService.rest.resource.ResourceException;
import java.util.ArrayList;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;

public class MemoryCachePost
implements RepositoryQuery {
    private final MessageContext context;

    public MemoryCachePost(MessageContext context) {
        this.context = context;
    }

    @Override
    public IQueryResult execute(RepositoryConnection connection) throws RepositoryException {
        IQueryResult result = null;
        HttpServletRequest request = (HttpServletRequest)this.context.getProperty("http_servlet_request");
        if (request.getHeader("Cognos-Gateway") != null) {
            throw new ResourceException(501, new Message((Resource.Id)RepositoryServiceErrors.REPS_REP.repositoryNoGatewayAccess));
        }
        MIMEPartParser parts = (MIMEPartParser)this.context.getProperty("request.attachments");
        result = this.handlePost(connection, parts);
        return result;
    }

    private IQueryResult handlePost(RepositoryConnection connection, MIMEPartParser parts) throws RepositoryException {
        DataDescriptorProperty data = new DataDescriptorProperty("data", (Object)parts);
        DataDescriptor descriptor = new DataDescriptor((IDataDescriptorProperty[])new DataDescriptorProperty[]{data});
        CacheSaveDataResult result = (CacheSaveDataResult)connection.writeData((IDataDescriptor)descriptor, new Properties());
        if (result.isSuccess()) {
            CacheID cacheID = result.getCacheID();
            ArrayList<DataDescriptor> resultInfo = new ArrayList<DataDescriptor>();
            DataDescriptor dd = new DataDescriptor();
            dd.addProperty((IDataDescriptorProperty)new DataDescriptorProperty("documentObjectID", (Object)cacheID));
            resultInfo.add(dd);
            QueryResultObjects results = new QueryResultObjects(resultInfo);
            QueryResult qresult = new QueryResult((IQueryResultObjects)results, false);
            return qresult;
        }
        throw new ResourceException(500, new Message((Resource.Id)RepositoryServiceErrors.REPS_REP.repositorySaveInCacheFailure));
    }
}

