/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryService.query;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public interface ParameterValidator {
    public static final ParameterValidator NON_NEGATIVE_INTEGER_VALIDATOR = new ParameterValidator(){

        @Override
        public boolean isValid(String value) {
            boolean isValid = false;
            if (value != null) {
                try {
                    isValid = Integer.valueOf(value) >= 0;
                }
                catch (NumberFormatException nfe) {
                    isValid = false;
                }
            }
            return isValid;
        }
    };
    public static final ParameterValidator STRING_VALIDATOR = new ParameterValidator(){

        @Override
        public boolean isValid(String value) {
            boolean isValid = false;
            if (value != null) {
                isValid = true;
            }
            return isValid;
        }
    };
    public static final ParameterValidator IMAGE_QUERY_VALIDATOR = new ParameterValidator(){
        private static final String QUERY_REGEX = "graphic\\[@name=((%22)|(\")).*((%22)|(\"))\\]$";
        private final Pattern queryPattern = Pattern.compile("graphic\\[@name=((%22)|(\")).*((%22)|(\"))\\]$");

        @Override
        public boolean isValid(String value) {
            boolean isValid = false;
            if (value != null) {
                Matcher matcher = this.queryPattern.matcher(value);
                isValid = matcher.find();
            }
            return isValid;
        }
    };
    public static final ParameterValidator BOOLEAN_VALIDATOR = new ParameterValidator(){

        @Override
        public boolean isValid(String value) {
            boolean isValid = false;
            if (value != null && !(isValid = Boolean.TRUE.toString().equals(value))) {
                isValid = Boolean.FALSE.toString().equals(value);
            }
            return isValid;
        }
    };

    public boolean isValid(String var1);
}

