/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryService.query;

import com.ibm.cognos.cm.repositoryService.query.ParameterValidator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum QueryParameterNames {
    COUNT("ps", ParameterValidator.NON_NEGATIVE_INTEGER_VALIDATOR),
    SKIP("si", ParameterValidator.NON_NEGATIVE_INTEGER_VALIDATOR),
    IMAGE_QUERY("search", ParameterValidator.IMAGE_QUERY_VALIDATOR),
    DOWNLOAD("download", ParameterValidator.BOOLEAN_VALIDATOR),
    VERSION("version", ParameterValidator.NON_NEGATIVE_INTEGER_VALIDATOR),
    FORMAT_HINT("formatHint", ParameterValidator.STRING_VALIDATOR),
    LOCALE_HINT("localeHint", ParameterValidator.STRING_VALIDATOR);

    private static final Map<String, QueryParameterNames> parameterMap;
    private final ParameterValidator validator;
    private final String uriName;

    private QueryParameterNames(String uriName, ParameterValidator validator) {
        this.validator = validator;
        this.uriName = uriName;
    }

    public ParameterValidator getValidator() {
        return this.validator;
    }

    public String toString() {
        return this.uriName;
    }

    public static QueryParameterNames valueOfPathName(String pathName) {
        QueryParameterNames parameterName = parameterMap.get(pathName);
        if (parameterName == null) {
            throw new IllegalArgumentException(pathName);
        }
        return parameterName;
    }

    private static Map<String, QueryParameterNames> createParameterMap() {
        ConcurrentHashMap<String, QueryParameterNames> parameterMap = new ConcurrentHashMap<String, QueryParameterNames>();
        for (QueryParameterNames parameterName : QueryParameterNames.values()) {
            parameterMap.put(parameterName.uriName, parameterName);
        }
        return parameterMap;
    }

    static {
        parameterMap = QueryParameterNames.createParameterMap();
    }
}

