/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryService.query;

import com.cognos.cm.client.cmapi.HttpCommand;
import com.cognos.cm.client.cmapi.HttpCommandFactory;
import com.cognos.cm.repositoryPluginAPI.DataDescriptorProperty;
import com.cognos.cm.repositoryPluginAPI.IDataDescriptor;
import com.cognos.cm.repositoryPluginAPI.IDataDescriptorProperty;
import com.cognos.cm.repositoryPluginAPI.IQueryResult;
import com.cognos.cm.repositoryPluginAPI.IQueryResultObjects;
import com.cognos.cm.repositoryPluginAPI.RepositoryConnection;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.repositoryPluginFramework.DataDescriptor;
import com.cognos.cm.repositoryPluginFramework.QueryResult;
import com.cognos.cm.repositoryPluginFramework.QueryResultObjects;
import com.cognos.cm.repositoryPluginFramework.RepositoryPluginErrors;
import com.cognos.cmutils.messages.Resource;
import com.cognos.pogo.pdk.MessageContext;
import com.ibm.cognos.cm.repositoryService.query.RepositoryQuery;
import com.ibm.cognos.cm.repositoryService.rest.resource.ResourceName;
import com.ibm.cognos.cm.repositoryService.rest.resource.URIResource;
import com.ibm.json.java.JSON;
import com.ibm.json.java.JSONArray;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RepositoryReportQuery
implements RepositoryQuery {
    static final String DATASOURCE_LOOKUP_REQUEST_PREFIX = "/1.0/functions/repositoryDataSourceLookup?id=";
    public static final String REPORT_URI = "reportURI";
    public static final String REPOSITORY_IDENTIFIER = "repositoryID";
    private final MessageContext context;
    private final HttpCommandFactory commandFactory;
    private final URIResource requestedResource;
    private final List<IDataDescriptor> results;

    public RepositoryReportQuery(URIResource requestedResource, HttpCommandFactory commandFactory, MessageContext context) {
        this.requestedResource = requestedResource;
        this.commandFactory = commandFactory;
        this.context = context;
        this.results = new ArrayList<IDataDescriptor>();
    }

    @Override
    public IQueryResult execute(RepositoryConnection connection) throws RepositoryException {
        this.addREPSResult();
        return this.createQueryResult();
    }

    private void addREPSResult() throws RepositoryException {
        String reportID = this.requestedResource.getResourceId();
        List<String> repositoryIDs = this.repositoryDataSourceLookup(reportID);
        for (String repositoryID : repositoryIDs) {
            DataDescriptor repositoryLink = this.createDataDescriptor(reportID, repositoryID);
            this.results.add((IDataDescriptor)repositoryLink);
        }
    }

    private String createReportURI(String repositoryID, String reportID) {
        StringBuilder redirectUriBuffer = new StringBuilder("/");
        redirectUriBuffer.append(ResourceName.ROOT.toString()).append("/");
        redirectUriBuffer.append(ResourceName.REPOSITORY.toString()).append("/");
        redirectUriBuffer.append(repositoryID).append("/");
        redirectUriBuffer.append(ResourceName.REPORT.toString()).append("/");
        redirectUriBuffer.append(reportID);
        return redirectUriBuffer.toString();
    }

    private List<String> repositoryDataSourceLookup(String resourceId) throws RepositoryException {
        ArrayList<String> dataSourceIds;
        block4: {
            dataSourceIds = new ArrayList<String>();
            try {
                String requestURI = DATASOURCE_LOOKUP_REQUEST_PREFIX + resourceId;
                HttpCommand command = this.commandFactory.getCommand(this.context, requestURI);
                int responseCode = command.execute();
                if (200 == responseCode) {
                    JSONArray response = (JSONArray)JSON.parse((String)command.getResponseBody());
                    Iterator responseIterator = response.iterator();
                    while (responseIterator.hasNext()) {
                        dataSourceIds.add(responseIterator.next().toString());
                    }
                    break block4;
                }
                throw new RepositoryException((Resource.Id)RepositoryPluginErrors.REP_API.repositoryError);
            }
            catch (Exception e) {
                throw new RepositoryException((Resource.Id)RepositoryPluginErrors.REP_API.repositoryError, (Throwable)e);
            }
        }
        return dataSourceIds;
    }

    private IQueryResult createQueryResult() {
        QueryResultObjects resultObjects = new QueryResultObjects(this.results);
        return new QueryResult((IQueryResultObjects)resultObjects, true);
    }

    private DataDescriptor createDataDescriptor(String reportID, String repositoryID) {
        String redirectURI = this.createReportURI(repositoryID, reportID);
        DataDescriptor descriptor = new DataDescriptor();
        descriptor.addProperty((IDataDescriptorProperty)new DataDescriptorProperty(REPORT_URI, (Object)redirectURI));
        descriptor.addProperty((IDataDescriptorProperty)new DataDescriptorProperty(REPOSITORY_IDENTIFIER, (Object)repositoryID));
        return descriptor;
    }
}

