/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryService.response;

import com.cognos.cm.repositoryPluginAPI.IQueryResult;
import com.cognos.cm.repositoryPluginAPI.IQueryResultObjects;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.repositoryPluginFramework.RepositoryPluginErrors;
import com.cognos.cmutils.messages.Resource;
import com.cognos.cmutils.url.CMURLEncoder;
import com.cognos.pogo.pdk.MessageContext;
import com.ibm.cognos.cm.repositoryService.authorization.AuthorizationAdapter;
import com.ibm.cognos.cm.repositoryService.query.QueryParameterNames;
import com.ibm.cognos.cm.repositoryService.query.RepositoryQuery;
import com.ibm.cognos.cm.repositoryService.response.BaseURLResponder;
import com.ibm.cognos.cm.repositoryService.rest.resource.ResourceName;
import com.ibm.cognos.cm.repositoryService.rest.resource.URIResource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import org.apache.abdera.Abdera;
import org.apache.abdera.writer.StreamWriter;

abstract class AtomResponder
extends BaseURLResponder {
    protected static final String CONTENT_TYPE_HEADER = "Content-Type: ";
    protected static final String CHARSET_UTF8 = "; charset=UTF-8";
    protected static final String FEED_AUTHOR = "NONE";
    protected static final String ATOM_TYPE = "application/atom+xml";
    protected static final String TAG_IBM_COM_2012 = "tag:ibm.com,2012:";
    protected static final String CRLF = "\r\n";
    protected static final String SRC_ATTRIBUTE = "src";
    protected static final String OCTET_TYPE = "application/octet-stream";
    protected static final String EMPTY_STRING = "";
    protected static final String COG_EXT_NS = "http://www.ibm.com/xmlns/prod/cognos/repositoryServiceAtom/201204";
    protected static final int LINK_TYPE_NEXT = 1;
    protected static final int LINK_TYPE_PREV = 2;
    protected static final int LINK_TYPE_FIRST = 3;
    protected static final int LINK_TYPE_SELF = 4;
    protected final StreamWriter feedWriter;
    protected String gatewayURL;
    final Integer reqPageSize;
    final Integer reqSkip;

    public AtomResponder(URIResource resource, String gatewayConfigURL) {
        super(gatewayConfigURL);
        this.feedWriter = Abdera.getNewStreamWriter();
        this.feedWriter.setAutoclose(true);
        this.feedWriter.setAutoflush(true);
        this.feedWriter.setAutoIndent(true);
        this.reqPageSize = this.extractIntegerParameter(QueryParameterNames.COUNT.name(), resource);
        this.reqSkip = this.extractIntegerParameter(QueryParameterNames.SKIP.name(), resource);
    }

    AtomResponder(StreamWriter writer, String gatewayConfigURL, Integer pageSize, Integer skip) {
        super(gatewayConfigURL);
        this.feedWriter = writer;
        this.reqPageSize = pageSize;
        this.reqSkip = skip;
    }

    protected abstract String getFeedID();

    protected abstract String getBaseLink();

    private String getSelfLink() {
        return this.getBaseLink() + this.buildPageParameters(4);
    }

    private String getFirstLink() {
        return this.getBaseLink() + this.buildPageParameters(3);
    }

    private String getNextLink() {
        return this.getBaseLink() + this.buildPageParameters(1);
    }

    private String getPrevLink() {
        return this.getBaseLink() + this.buildPageParameters(2);
    }

    protected abstract String getFeedTitle();

    protected abstract void writeEntry(IQueryResultObjects var1);

    @Override
    public void respond(IQueryResult result, MessageContext context, AuthorizationAdapter adaptor) throws RepositoryException {
        try {
            this.setResponseEnvelope(context);
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            this.writeContentType(buffer);
            if (this.gatewayURL == null) {
                this.gatewayURL = this.buildBaseAbsoluteURL(context);
            }
            IQueryResultObjects objects = result.getObjects();
            this.feedWriter.setOutputStream((OutputStream)buffer);
            this.writeFeedPreamble();
            if (objects != null) {
                if (objects.size() >= (this.reqPageSize != null ? this.reqPageSize.intValue() : RepositoryQuery.DEFAULT_PAGE_SIZE.intValue())) {
                    this.feedWriter.writeLink(this.getNextLink(), "next", ATOM_TYPE);
                }
                while (objects.next()) {
                    this.writeEntry(objects);
                }
            }
            this.writeFeedPostamble();
            ByteArrayInputStream is = new ByteArrayInputStream(buffer.toByteArray());
            ArrayList<InputStream> list = new ArrayList<InputStream>();
            list.add(is);
            this.respondAsAttachment(context, list, 200);
        }
        catch (IOException e) {
            throw new RepositoryException((Resource.Id)RepositoryPluginErrors.REP_API.repositoryError, (Throwable)e);
        }
    }

    private void writeContentType(ByteArrayOutputStream buffer) throws UnsupportedEncodingException, IOException {
        OutputStreamWriter osWriter = new OutputStreamWriter((OutputStream)buffer, "UTF-8");
        osWriter.write(CONTENT_TYPE_HEADER);
        osWriter.write(ATOM_TYPE);
        osWriter.write(CHARSET_UTF8);
        osWriter.write(CRLF);
        osWriter.write(CRLF);
        osWriter.flush();
    }

    protected void writeFeedPostamble() {
        this.feedWriter.endFeed();
        this.feedWriter.endDocument();
    }

    protected void writeFeedPreamble() {
        this.feedWriter.startDocument();
        this.feedWriter.startFeed();
        this.feedWriter.writeId(this.getFeedID());
        this.feedWriter.writeTitle(this.getFeedTitle());
        this.feedWriter.writeAuthor(FEED_AUTHOR);
        this.feedWriter.writeUpdated(new Date());
        this.feedWriter.writeLink(this.getSelfLink(), "self", ATOM_TYPE);
        this.feedWriter.writeLink(this.getFirstLink(), "first", ATOM_TYPE);
        if (this.hasPreviousPage()) {
            this.feedWriter.writeLink(this.getPrevLink(), "previous", ATOM_TYPE);
        }
    }

    protected String buildVersionOutputsURL(String dataSourceID, String reportID, String versionID) {
        StringBuilder selfURIBuilder = new StringBuilder();
        selfURIBuilder.append(this.gatewayURL);
        selfURIBuilder.append("/");
        selfURIBuilder.append((Object)ResourceName.ROOT);
        selfURIBuilder.append("/");
        selfURIBuilder.append((Object)ResourceName.REPOSITORY);
        selfURIBuilder.append("/");
        selfURIBuilder.append(dataSourceID);
        selfURIBuilder.append("/");
        selfURIBuilder.append((Object)ResourceName.REPORT);
        selfURIBuilder.append("/");
        selfURIBuilder.append(reportID);
        selfURIBuilder.append("/");
        selfURIBuilder.append((Object)ResourceName.REPORTVERSION);
        selfURIBuilder.append("/");
        selfURIBuilder.append(CMURLEncoder.encode((String)versionID));
        return selfURIBuilder.toString();
    }

    String buildPageParameters(int linkType) {
        StringBuilder builder = new StringBuilder();
        Integer ps = this.reqPageSize;
        Integer si = null;
        switch (linkType) {
            case 3: {
                si = this.reqSkip != null ? Integer.valueOf(0) : null;
                break;
            }
            case 1: {
                si = this.reqSkip != null ? this.reqSkip : RepositoryQuery.DEFAULT_SKIP;
                si = si + (this.reqPageSize != null ? this.reqPageSize : RepositoryQuery.DEFAULT_PAGE_SIZE);
                break;
            }
            case 2: {
                if (this.reqSkip != null) {
                    si = this.reqSkip - (this.reqPageSize != null ? this.reqPageSize : RepositoryQuery.DEFAULT_PAGE_SIZE);
                }
                si = si != null ? (si < 0 ? Integer.valueOf(0) : si) : si;
                break;
            }
            case 4: {
                si = this.reqSkip;
                break;
            }
            default: {
                ps = null;
            }
        }
        if (ps != null && si != null) {
            builder.append("?");
            builder.append(QueryParameterNames.COUNT.toString()).append("=").append(ps.toString());
            builder.append("&");
            builder.append(QueryParameterNames.SKIP.toString()).append("=").append(si.toString());
        } else if (ps != null && si == null) {
            builder.append("?");
            builder.append(QueryParameterNames.COUNT.toString()).append("=").append(ps.toString());
        } else if (ps == null && si != null) {
            builder.append("?");
            builder.append(QueryParameterNames.SKIP.toString()).append("=").append(si.toString());
        }
        return builder.toString();
    }

    boolean hasPreviousPage() {
        Integer si = this.reqSkip != null ? this.reqSkip : RepositoryQuery.DEFAULT_SKIP;
        return si > 0;
    }

    private Integer extractIntegerParameter(String parameterName, URIResource resource) {
        String paramValue = resource.getParameter(parameterName);
        if (paramValue == null) {
            return null;
        }
        return Integer.valueOf(paramValue);
    }
}

