/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryService.response;

import com.cognos.cm.repositoryPluginAPI.IQueryResultObjects;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.repositoryPluginFramework.RepositoryPluginErrors;
import com.cognos.cmutils.messages.Resource;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.util.StringUtils;
import com.ibm.cognos.cm.repositoryService.HTTPHeaders;
import com.ibm.cognos.cm.repositoryService.response.Responder;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class BaseResponder
implements Responder {
    void respondAsAttachment(MessageContext mc, List<InputStream> attachmentList, int status) {
        mc.setProperty("response.attachments", attachmentList.iterator());
        mc.setProperty("response.boundary", (Object)StringUtils.getUniqueValue());
        mc.setProperty("response.status_code", (Object)Integer.toString(status));
    }

    void setResponseEnvelope(MessageContext mc) {
        BIBusEnvelope bus = (BIBusEnvelope)mc.getProperty("request.envelope");
        mc.setResponseName("response");
        mc.setProperty("response.envelope", (Object)bus);
    }

    void validateResult(IQueryResultObjects objects) throws RepositoryException {
        if (objects == null || !objects.next()) {
            throw new RepositoryException((Resource.Id)RepositoryPluginErrors.REP_API.noQueryResults);
        }
    }

    public static HTTPHeaders extractHeaders(IQueryResultObjects objects) {
        Object obj = objects.getPropertyValue("headers");
        if (obj instanceof HTTPHeaders) {
            return (HTTPHeaders)obj;
        }
        Map map = obj instanceof Map ? (Map)obj : Collections.emptyMap();
        return new HTTPHeaders(map);
    }
}

