/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryService.response;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.ibm.cognos.cm.repositoryService.response.BaseResponder;
import com.ibm.cognos.cm.repositoryService.rest.resource.ResourceName;
import java.net.URI;
import java.net.URISyntaxException;
import javax.mail.internet.InternetHeaders;
import javax.servlet.http.HttpServletRequest;

public abstract class BaseURLResponder
extends BaseResponder {
    static final String HTTP_SERVLET_REQUEST = "http_servlet_request";
    static final String SEPARATOR = "/";
    final String gatewayConfigURL;

    public BaseURLResponder(String gatewayConfigURL) {
        this.gatewayConfigURL = gatewayConfigURL;
    }

    public final String buildBaseAbsoluteURL(MessageContext mc) {
        URI absoluteURI;
        BIBusEnvelope request = (BIBusEnvelope)mc.getProperty("request.envelope");
        InternetHeaders hdrs = (InternetHeaders)mc.getProperty("request.headers");
        String scheme = this.getScheme(hdrs, mc);
        String serverName = this.getValue(request, hdrs, "SERVER_NAME", "original-host");
        String serverPort = this.getValue(request, hdrs, "SERVER_PORT", "original-server_port");
        String serverPath = this.getValue(request, hdrs, "SCRIPT_NAME", "original-script-name");
        if (serverName == null || serverPath == null || serverPort == null) {
            return this.gatewayConfigURL;
        }
        try {
            absoluteURI = new URI(scheme, null, serverName, Integer.valueOf(serverPort), serverPath, null, null);
        }
        catch (NumberFormatException e) {
            return this.gatewayConfigURL;
        }
        catch (URISyntaxException e) {
            return this.gatewayConfigURL;
        }
        return absoluteURI.toString();
    }

    protected boolean isNullOrEmpty(Object value) {
        if (value == null) {
            return true;
        }
        return value.toString().isEmpty();
    }

    String getScheme(InternetHeaders hdrs, MessageContext mc) {
        String scheme = this.getOrigSchemeFromGateway(hdrs);
        if (this.isNullOrEmpty(scheme)) {
            scheme = this.getSchemeFromDispatcher(mc);
        }
        return scheme;
    }

    private String getOrigSchemeFromGateway(InternetHeaders hdrs) {
        String gateScheme = this.getHeaderValue(hdrs, "original-https");
        if ("on".equalsIgnoreCase(gateScheme)) {
            return "https";
        }
        return gateScheme;
    }

    private String getSchemeFromDispatcher(MessageContext mc) {
        String dispScheme;
        String prefix = "http";
        HttpServletRequest servletRequest = (HttpServletRequest)mc.getProperty(HTTP_SERVLET_REQUEST);
        if (servletRequest != null && !this.isNullOrEmpty(dispScheme = servletRequest.getScheme())) {
            prefix = dispScheme;
        }
        return prefix;
    }

    String getServerPath(MessageContext context) {
        BIBusEnvelope request = (BIBusEnvelope)context.getProperty("request.envelope");
        InternetHeaders hdrs = (InternetHeaders)context.getProperty("request.headers");
        return this.getValue(request, hdrs, "SCRIPT_NAME", "original-script-name");
    }

    String getValue(BIBusEnvelope request, InternetHeaders hdrs, String envHeader, String originalHeader) {
        String value = request.getEnvironmentValue(envHeader);
        if (this.isNullOrEmpty(value)) {
            value = this.getHeaderValue(hdrs, originalHeader);
        }
        return value;
    }

    private String getHeaderValue(InternetHeaders hdrs, String name) {
        String[] values;
        String value = null;
        if (hdrs != null && (values = hdrs.getHeader(name)) != null && values.length > 0) {
            value = values[0];
        }
        if (this.isNullOrEmpty(value)) {
            value = null;
        }
        return value;
    }

    String getBaseRepositoryURL(String dataSourceID) {
        StringBuilder uri = new StringBuilder(ResourceName.ROOT.toString());
        uri.append(SEPARATOR);
        uri.append((Object)ResourceName.REPOSITORY).append(SEPARATOR);
        uri.append(dataSourceID).append(SEPARATOR);
        return uri.toString();
    }
}

