/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryService.response;

import com.cognos.cm.repositoryPluginAPI.IQueryResult;
import com.cognos.cm.repositoryPluginAPI.IQueryResultObjects;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.repositoryPluginFramework.RepositoryPluginErrors;
import com.cognos.cmutils.messages.Resource;
import com.cognos.pogo.impl.PogoSOAPMessageResponder;
import com.cognos.pogo.pdk.MessageContext;
import com.ibm.cognos.cm.repositoryService.ByteRangeProcessor;
import com.ibm.cognos.cm.repositoryService.HTTPHeaders;
import com.ibm.cognos.cm.repositoryService.authorization.AuthorizationAdapter;
import com.ibm.cognos.cm.repositoryService.response.BaseResponder;
import com.ibm.cognos.cm.repositoryService.response.ContentResponder;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ByteServingResponder
extends BaseResponder {
    private static Log log = LogFactory.getLog(ByteServingResponder.class);
    private final ContentResponder contentResponder;
    private final ByteRangeProcessor byteRangeProcessor;

    public ByteServingResponder(ContentResponder contentResponder, ByteRangeProcessor byteRangeProcessor) {
        this.byteRangeProcessor = byteRangeProcessor;
        this.contentResponder = contentResponder;
    }

    @Override
    public void respond(IQueryResult result, MessageContext context, AuthorizationAdapter adaptor) throws RepositoryException {
        InputStream contentStream = null;
        IQueryResultObjects objects = result.getObjects();
        this.validateResult(objects);
        try {
            this.setResponseEnvelope(context);
            contentStream = this.contentResponder.getContentStream(objects);
            ArrayList<InputStream> attachmentList = new ArrayList<InputStream>();
            HTTPHeaders headers = ByteServingResponder.extractHeaders(objects);
            long docSize = headers.getDocumentSize();
            if (docSize != -1L) {
                this.byteRangeProcessor.setDocSize(docSize);
            }
            this.contentResponder.buildResponseHeaders(headers, context);
            boolean success = this.byteRangeProcessor.processRanges(attachmentList, contentStream, headers);
            if (!success) {
                attachmentList.add(new ByteArrayInputStream(new byte[0]));
                this.contentResponder.respondAsAttachment(context, attachmentList, 416);
                return;
            }
            int numberOfRanges = this.byteRangeProcessor.getNumberOfRanges();
            if (numberOfRanges > 1) {
                context.setProperty("pogo.responder", (Object)new PogoSOAPMessageResponder());
                context.setProperty("byteRanges", (Object)Integer.toString(numberOfRanges));
            }
            this.contentResponder.respondAsAttachment(context, attachmentList, 206);
        }
        catch (Exception e) {
            log.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            IOUtils.closeQuietly((InputStream)contentStream);
            throw new RepositoryException((Resource.Id)RepositoryPluginErrors.REP_API.repositoryError, (Throwable)e);
        }
    }
}

