/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryService.response;

import com.cognos.cm.repositoryPluginAPI.IQueryResult;
import com.cognos.cm.repositoryPluginAPI.IQueryResultObjects;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.repositoryPluginFramework.RepositoryPluginErrors;
import com.cognos.cmutils.http.HttpMethodFactory;
import com.cognos.cmutils.messages.Resource;
import com.cognos.pogo.pdk.MessageContext;
import com.ibm.cognos.cm.repositoryService.HTTPHeaders;
import com.ibm.cognos.cm.repositoryService.HeaderHelper;
import com.ibm.cognos.cm.repositoryService.authorization.AuthorizationAdapter;
import com.ibm.cognos.cm.repositoryService.cache.Cache;
import com.ibm.cognos.cm.repositoryService.cache.CachedItem;
import com.ibm.cognos.cm.repositoryService.response.CachedContentHelper;
import com.ibm.cognos.cm.repositoryService.response.ContentResponder;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.mail.MessagingException;
import net.sf.ehcache.Element;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CachedContentResponder
extends ContentResponder {
    private static Log log = LogFactory.getLog(CachedContentResponder.class);
    private final String cacheID;
    private final Cache cache;

    public CachedContentResponder(HttpMethodFactory httpMethodFactory, Cache cache, String cacheID) {
        this(httpMethodFactory, cache, cacheID, false);
    }

    public CachedContentResponder(HttpMethodFactory httpMethodFactory, Cache cache, String cacheID, boolean asAttachment) {
        super(httpMethodFactory, asAttachment);
        this.cache = cache;
        this.cacheID = cacheID;
    }

    @Override
    public void respond(IQueryResult result, MessageContext context, AuthorizationAdapter adaptor) throws RepositoryException {
        try {
            IQueryResultObjects objects = result.getObjects();
            this.validateResult(objects);
            InputStream contentStream = (InputStream)objects.getPropertyValue("contentStream");
            InputStream cachedStream = this.getCachedAttachmentStream();
            if (cachedStream != null) {
                IOUtils.closeQuietly((InputStream)contentStream);
                HTTPHeaders headers = HeaderHelper.parse(cachedStream);
                InputStream content = this.rebuildContentStream(cachedStream, headers, context);
                this.respondWithStream(context, content);
                return;
            }
            HTTPHeaders headers = CachedContentResponder.extractHeaders(objects);
            if (this.shouldChache(headers)) {
                InputStream content = this.rebuildContentStream(contentStream, headers, context);
                contentStream = this.saveOutputToCache(content);
                this.respondWithStream(context, contentStream);
            } else {
                objects.reset();
                this.respondNormally(result, context, adaptor);
            }
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (Exception e) {
            log.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            throw new RepositoryException((Resource.Id)RepositoryPluginErrors.REP_API.repositoryError, (Throwable)e);
        }
    }

    private boolean shouldChache(HTTPHeaders headers) {
        long documentSize = headers.getDocumentSize();
        return this.cache != null && documentSize != -1L && documentSize <= this.cache.maxDocSize();
    }

    @Override
    InputStream getContentStream(IQueryResultObjects objects) {
        InputStream content = null;
        if (this.cache != null) {
            content = CachedContentHelper.getCachedContentStream(this.cache, this.cacheID);
        }
        if (content == null) {
            content = (InputStream)objects.getPropertyValue("contentStream");
        }
        return content;
    }

    private InputStream getCachedAttachmentStream() {
        InputStream content = null;
        try {
            Element element;
            Element element2 = element = this.cache == null ? null : this.cache.get(this.cacheID);
            if (element != null) {
                CachedItem item = (CachedItem)element.getObjectValue();
                content = this.createAttachmentStream(item.getContentStream(), item.getHeaders());
            }
        }
        catch (UnsupportedEncodingException e) {
            log.debug((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return content;
    }

    @Override
    protected void buildResponseHeaders(HTTPHeaders headers, MessageContext mc) {
        super.buildResponseHeaders(headers, mc);
        headers.put("Accept-Ranges", "bytes");
    }

    void respondNormally(IQueryResult result, MessageContext context, AuthorizationAdapter adaptor) throws RepositoryException {
        super.respond(result, context, adaptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream saveOutputToCache(InputStream is) throws IOException, MessagingException {
        try {
            long expiry = this.getDefaultExpiry();
            Element result = this.cache.put(this.cacheID, is, false, expiry);
            CachedItem item = (CachedItem)result.getObjectValue();
            InputStream inputStream = this.createAttachmentStream(item.getContentStream(), item.getHeaders());
            return inputStream;
        }
        finally {
            is.close();
        }
    }
}

