/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryService.response;

import com.cognos.cm.repositoryPluginAPI.IQueryResult;
import com.cognos.cm.repositoryPluginAPI.IQueryResultObjects;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.repositoryPluginFramework.RepositoryPluginErrors;
import com.cognos.cmutils.http.HttpMethodFactory;
import com.cognos.cmutils.messages.Resource;
import com.cognos.pogo.pdk.MessageContext;
import com.ibm.cognos.cm.repositoryService.HTTPHeaders;
import com.ibm.cognos.cm.repositoryService.HeaderHelper;
import com.ibm.cognos.cm.repositoryService.RepositoryServiceErrors;
import com.ibm.cognos.cm.repositoryService.authorization.AuthorizationAdapter;
import com.ibm.cognos.cm.repositoryService.response.BaseResponder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.mail.internet.InternetHeaders;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContentResponder
extends BaseResponder {
    private static final long EXPIRY_ONE_YEAR = 31449600000L;
    private static final String MULTI_PART_MIME = "message/rfc822";
    private static final String CONTENT_TRANSFER_ENCODING = "Content-Transfer-Encoding";
    private SimpleDateFormat formatter = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
    private final HttpMethodFactory httpMethodFactory;
    private final boolean asAttachment;
    private static Log log = LogFactory.getLog(ContentResponder.class);

    public ContentResponder(HttpMethodFactory httpMethodFactory) {
        this(httpMethodFactory, false);
    }

    public ContentResponder(HttpMethodFactory httpMethodFactory, boolean asAttachment) {
        this.httpMethodFactory = httpMethodFactory;
        this.asAttachment = asAttachment;
    }

    @Override
    public void respond(IQueryResult result, MessageContext context, AuthorizationAdapter adapter) throws RepositoryException {
        IQueryResultObjects objects = result.getObjects();
        this.validateResult(objects);
        try {
            InputStream contentStream = this.getContentStream(objects);
            if (null != objects.getPropertyValue("recipients") && !adapter.hasBurstAccess(context, objects, this.httpMethodFactory)) {
                contentStream.close();
                throw new RepositoryException((Resource.Id)RepositoryServiceErrors.REPS_REP.repositorySecurityError);
            }
            Map headersMap = (Map)objects.getPropertyValue("headers");
            HTTPHeaders headers = headersMap != null ? new HTTPHeaders(headersMap) : new HTTPHeaders();
            InputStream content = this.rebuildContentStream(contentStream, headers, context);
            this.respondWithStream(context, content);
        }
        catch (IOException ioe) {
            log.debug((Object)ioe.getLocalizedMessage(), (Throwable)ioe);
            throw new RepositoryException((Resource.Id)RepositoryPluginErrors.REP_API.repositoryError, (Throwable)ioe);
        }
    }

    InputStream getContentStream(IQueryResultObjects objects) {
        return (InputStream)objects.getPropertyValue("contentStream");
    }

    InputStream createAttachmentStream(InputStream contentStream, HTTPHeaders headers) throws UnsupportedEncodingException {
        byte[] headerBytes = headers.toByteArray();
        SequenceInputStream content = new SequenceInputStream(new ByteArrayInputStream(headerBytes), contentStream);
        return content;
    }

    protected void buildResponseHeaders(HTTPHeaders headers, MessageContext mc) {
        if (headers != null && headers.size() > 0) {
            String userAgent = this.getUserAgent(mc);
            this.buildContentDispositionHeader(headers, userAgent);
            String contentType = headers.get("Content-Type");
            if (contentType != null && (contentType.contains(MULTI_PART_MIME) || contentType.contains("application/PDF"))) {
                headers.put(CONTENT_TRANSFER_ENCODING, "8bit");
            }
        }
    }

    void buildContentDispositionHeader(HTTPHeaders headers, String userAgent) {
        String originalDispHeader = headers.get("Content-Disposition");
        if (originalDispHeader != null) {
            String contentType = headers.get("Content-Type");
            String dispositionValue = HeaderHelper.rebuildDispositionHeader(originalDispHeader, contentType, userAgent, this.asAttachment);
            headers.put("Content-Disposition", dispositionValue);
        }
    }

    private String getUserAgent(MessageContext mc) {
        HttpServletRequest request = (HttpServletRequest)mc.getProperty("http_servlet_request");
        return request.getHeader("User-Agent");
    }

    protected void setCacheHeaders(HTTPHeaders headers) {
        headers.put("Cache-control", "private");
        long expirationTime = this.getDefaultExpiry();
        headers.put("Expires", this.formatter.format(expirationTime));
    }

    long getDefaultExpiry() {
        return System.currentTimeMillis() + 31449600000L;
    }

    public void respondWithStream(MessageContext mc, InputStream contentStream) {
        this.setResponseEnvelope(mc);
        ArrayList<InputStream> attachmentList = new ArrayList<InputStream>();
        attachmentList.add(contentStream);
        this.respondAsAttachment(mc, attachmentList, 200);
    }

    protected InputStream rebuildContentStream(InputStream content, HTTPHeaders headers, MessageContext context) throws IOException {
        this.buildResponseHeaders(headers, context);
        this.setCacheHeaders(headers);
        if (this.shouldUncompress(context, headers)) {
            this.removeEncodingAndLengthHeaders(headers);
            content = new GZIPInputStream(content);
        }
        return this.createAttachmentStream(content, headers);
    }

    protected boolean shouldUncompress(MessageContext mc, HTTPHeaders headers) {
        InternetHeaders requestHeaders = (InternetHeaders)mc.getProperty("request.headers");
        String acceptEncoding = requestHeaders.getHeader("Accept-Encoding", null);
        String contentEncoding = headers.get("Content-Encoding");
        return !this.isGzip(acceptEncoding) && this.isGzip(contentEncoding);
    }

    protected void removeEncodingAndLengthHeaders(HTTPHeaders headers) {
        headers.remove("Content-Length");
        headers.remove("Content-Encoding");
    }

    protected boolean isGzip(String header) {
        if (header != null) {
            return header.contains("gzip");
        }
        return false;
    }
}

