/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryService.response;

import com.cognos.cm.repositoryPluginAPI.IQueryResult;
import com.cognos.cm.repositoryPluginAPI.IQueryResultObjects;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.repositoryPluginFramework.RepositoryPluginErrors;
import com.cognos.cmutils.messages.Message;
import com.cognos.cmutils.messages.Resource;
import com.cognos.pogo.pdk.MessageContext;
import com.ibm.cognos.cm.repositoryService.HTTPHeaders;
import com.ibm.cognos.cm.repositoryService.RepositoryServiceErrors;
import com.ibm.cognos.cm.repositoryService.authorization.AuthorizationAdapter;
import com.ibm.cognos.cm.repositoryService.cache.connection.CacheID;
import com.ibm.cognos.cm.repositoryService.response.BaseURLResponder;
import com.ibm.json.java.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;

public class CreatedResponder
extends BaseURLResponder {
    private final String resourcePath;

    public CreatedResponder(String gatewayConfigURL, String resourcePath) {
        super(gatewayConfigURL);
        this.resourcePath = resourcePath;
    }

    @Override
    public void respond(IQueryResult result, MessageContext context, AuthorizationAdapter adaptor) throws RepositoryException {
        try {
            CacheID id = null;
            IQueryResultObjects resultObjects = result.getObjects();
            if (resultObjects.next()) {
                id = (CacheID)resultObjects.getPropertyValue("documentObjectID");
            }
            if (id == null) {
                Message message = new Message((Resource.Id)RepositoryServiceErrors.REPS_DET.repositoryMissingID);
                message.addDetail((Resource.Id)RepositoryPluginErrors.REP_API.repositoryError);
                throw new RepositoryException(message);
            }
            StringBuffer resource = new StringBuffer();
            resource.append(this.resourcePath).append(id.toURIString());
            String path = this.getServerPath(context);
            StringBuffer locationURL = new StringBuffer();
            locationURL.append(path).append(resource);
            JSONObject response = new JSONObject();
            response.put((Object)"Location", (Object)locationURL.toString());
            response.put((Object)"X-Cogweb-Location", (Object)resource.toString());
            byte[] contentBytes = response.serialize(true).getBytes("UTF-8");
            HTTPHeaders headers = new HTTPHeaders();
            headers.put("Location", locationURL.toString());
            headers.put("X-Cogweb-Location", resource.toString());
            headers.put("Content-Length", "" + contentBytes.length);
            headers.put("Content-Type", "application/json");
            byte[] headerBytes = headers.toByteArray();
            ArrayList<InputStream> attachments = new ArrayList<InputStream>();
            ByteArrayInputStream header = new ByteArrayInputStream(headerBytes);
            ByteArrayInputStream entity = new ByteArrayInputStream(contentBytes);
            SequenceInputStream content = new SequenceInputStream(header, entity);
            attachments.add(content);
            this.setResponseEnvelope(context);
            this.respondAsAttachment(context, attachments, 201);
        }
        catch (IOException e) {
            throw new RepositoryException((Resource.Id)RepositoryPluginErrors.REP_API.repositoryError, (Throwable)e);
        }
    }
}

