/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryService.response;

import com.cognos.cm.repositoryPluginAPI.IQueryResult;
import com.cognos.cm.repositoryPluginAPI.IQueryResultObjects;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.repositoryPluginFramework.RepositoryPluginErrors;
import com.cognos.cmutils.http.HttpMethodFactory;
import com.cognos.cmutils.messages.Message;
import com.cognos.cmutils.messages.Resource;
import com.cognos.pogo.pdk.MessageContext;
import com.ibm.cognos.cm.repositoryService.HTTPHeaders;
import com.ibm.cognos.cm.repositoryService.RepositoryServiceErrors;
import com.ibm.cognos.cm.repositoryService.authorization.AuthorizationAdapter;
import com.ibm.cognos.cm.repositoryService.cache.Cache;
import com.ibm.cognos.cm.repositoryService.cache.CachedItem;
import com.ibm.cognos.cm.repositoryService.response.ContentResponder;
import com.ibm.cognos.cm.repositoryService.rest.resource.ResourceException;
import com.ibm.cognos.cm.repositoryService.rest.resource.ServiceResource;
import com.ibm.cognos.cm.repositoryService.rest.resource.URIResource;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.util.Map;
import javax.mail.MessagingException;
import net.sf.ehcache.Element;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MHTContentResponder
extends ContentResponder {
    private static Log log = LogFactory.getLog(MHTContentResponder.class);
    private URIResource resource;
    private String cacheID;
    private final Cache cache;

    public MHTContentResponder(HttpMethodFactory httpMethodFactory, Cache cache, ServiceResource resource) {
        this(httpMethodFactory, cache, resource, false);
    }

    public MHTContentResponder(HttpMethodFactory httpMethodFactory, Cache cache, ServiceResource resource, boolean asAttachment) {
        super(httpMethodFactory, asAttachment);
        this.resource = resource.getURIResource();
        this.cacheID = resource.getCacheID();
        this.cache = cache;
    }

    @Override
    public void respond(IQueryResult result, MessageContext context, AuthorizationAdapter adaptor) throws RepositoryException {
        try {
            IQueryResultObjects objects = result.getObjects();
            this.validateResult(objects);
            InputStream cachedStream = this.getCachedAttachmentStream();
            if (cachedStream != null) {
                this.respondWithStream(context, cachedStream);
                return;
            }
            InputStream contentStream = this.getContentStream(objects);
            HTTPHeaders headers = new HTTPHeaders((Map)objects.getPropertyValue("headers"));
            if (!headers.isMHT()) {
                throw new ResourceException(404, new Message((Resource.Id)RepositoryPluginErrors.REP_API.invalidOutputID));
            }
            long documentSize = headers.getDocumentSize();
            this.checkMaxDocSize(documentSize);
            this.buildResponseHeaders(headers, context);
            this.setCacheHeaders(headers);
            InputStream content = this.createAttachmentStream(contentStream, headers);
            this.saveOutputToCache(content);
            this.respondWithStream(context, this.getCachedAttachmentStream());
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (ResourceException e) {
            throw e;
        }
        catch (Exception e) {
            log.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            throw new RepositoryException((Resource.Id)RepositoryPluginErrors.REP_API.repositoryError, (Throwable)e);
        }
    }

    private void checkMaxDocSize(long documentSize) throws RepositoryException {
        if (documentSize > this.cache.maxDocSize()) {
            Message message = new Message((Resource.Id)RepositoryServiceErrors.REPS_REP.repositoryCacheLimitExceeded);
            Message detailMessage = new Message((Resource.Id)RepositoryServiceErrors.REPS_REP.repositoryCacheLimitExceededDetail);
            double mb = (double)this.cache.maxDocSize() / 1024.0 / 1024.0;
            DecimalFormat format = new DecimalFormat("#.00");
            detailMessage.param("size", format.format(mb));
            throw new RepositoryException(message, (Throwable)new RepositoryException(detailMessage));
        }
    }

    private InputStream getCachedAttachmentStream() {
        InputStream content = null;
        try {
            Element element = this.cache.get(this.cacheID);
            if (element != null) {
                CachedItem item = (CachedItem)element.getValue();
                String fileName = this.resource.getParameter("fileName");
                content = fileName != null ? this.getCachePartStream(item, fileName) : this.createAttachmentStream(item.getContentStream(), item.getHeaders());
            }
        }
        catch (UnsupportedEncodingException e) {
            log.debug((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return content;
    }

    private InputStream getCachePartStream(CachedItem item, String fileName) throws UnsupportedEncodingException {
        if (!item.hasPart(fileName)) {
            throw new ResourceException(404, new Message((Resource.Id)RepositoryPluginErrors.REP_API.invalidOutputID));
        }
        InputStream content = this.createAttachmentStream(item.getContentStream(fileName), item.getHeaders(fileName));
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveOutputToCache(InputStream is) throws IOException, MessagingException {
        try {
            long expiry = this.getDefaultExpiry();
            this.cache.put(this.cacheID, is, true, expiry);
        }
        finally {
            is.close();
        }
    }
}

