/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryService.response;

import com.cognos.cm.repositoryPluginAPI.IQueryResultObjects;
import com.cognos.cmutils.url.CMURLEncoder;
import com.ibm.cognos.cm.repositoryService.response.AtomResponder;
import com.ibm.cognos.cm.repositoryService.rest.resource.ResourceName;
import com.ibm.cognos.cm.repositoryService.rest.resource.URIResource;
import java.util.Calendar;
import javax.xml.namespace.QName;
import org.apache.abdera.model.Text;
import org.apache.abdera.writer.StreamWriter;

public class OutputFileListResponder
extends AtomResponder {
    final String outputID;
    final String dataSourceID;

    public OutputFileListResponder(URIResource resource, String gatewayConfigURL) {
        super(resource, gatewayConfigURL);
        this.outputID = resource.getResourceId(ResourceName.OUTPUT);
        this.dataSourceID = resource.getResourceId(ResourceName.REPOSITORY);
    }

    OutputFileListResponder(String dataSourceID, String outputID, StreamWriter writer, String gatewayConfigURL, Integer pagesize, Integer skip) {
        super(writer, gatewayConfigURL, pagesize, skip);
        this.outputID = outputID;
        this.dataSourceID = dataSourceID;
    }

    @Override
    protected String getFeedID() {
        return "tag:ibm.com,2012:" + CMURLEncoder.encode((String)this.outputID);
    }

    @Override
    protected String getBaseLink() {
        return this.getGateway() + this.getOutputImageBaseURI(this.outputID);
    }

    @Override
    protected String getFeedTitle() {
        return this.outputID;
    }

    @Override
    protected void writeEntry(IQueryResultObjects object) {
        String outputStoreID = object.getPropertyValue("reportOutputStoreID").toString();
        String encodedObjectID = CMURLEncoder.encode((String)outputStoreID);
        String name = (String)object.getPropertyValue("defaultName");
        String objectURL = this.buildImageURL(encodedObjectID, name);
        String contentType = (String)object.getPropertyValue("contentType");
        contentType = contentType != null ? contentType : "application/octet-stream";
        String objectID = object.getPropertyValue("repositoryObjectId").toString();
        this.feedWriter.startEntry();
        this.feedWriter.writeId("tag:ibm.com,2012:" + objectID);
        this.feedWriter.writeTitle(name);
        this.feedWriter.writeText(new QName("http://www.ibm.com/xmlns/prod/cognos/repositoryServiceAtom/201204", "objectID"), Text.Type.TEXT, objectID);
        this.feedWriter.writeSummary("");
        this.feedWriter.writeUpdated(((Calendar)object.getPropertyValue("creationTime")).getTime());
        this.feedWriter.writeLink(objectURL, "alternate", contentType);
        this.feedWriter.startContent(contentType);
        this.feedWriter.writeAttribute("src", objectURL);
        this.feedWriter.endContent();
        this.feedWriter.writeText(new QName("http://www.ibm.com/xmlns/prod/cognos/repositoryServiceAtom/201204", "defaultName"), Text.Type.TEXT, name);
        this.feedWriter.endEntry();
    }

    private String buildImageURL(String objectID, String imageName) {
        StringBuilder uri = new StringBuilder();
        uri.append(this.getGateway());
        uri.append(this.getOutputImageBaseURI(objectID));
        uri.append("/" + imageName);
        return uri.toString();
    }

    private String getGateway() {
        StringBuilder gateway = new StringBuilder();
        if (this.gatewayURL != null) {
            gateway.append(this.gatewayURL);
        }
        if (this.gatewayURL == null || !this.gatewayURL.endsWith("/")) {
            gateway.append("/");
        }
        return gateway.toString();
    }

    private String getOutputImageBaseURI(String outputId) {
        StringBuilder uri = new StringBuilder(this.getBaseRepositoryURL(this.dataSourceID));
        uri.append((Object)ResourceName.OUTPUT).append("/");
        uri.append(outputId).append("/");
        uri.append("images");
        return uri.toString();
    }
}

