/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryService.response;

import com.cognos.cm.repositoryPluginAPI.IQueryResult;
import com.cognos.cm.repositoryPluginAPI.IQueryResultObjects;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.repositoryPluginFramework.RepositoryPluginErrors;
import com.cognos.cmutils.messages.Resource;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.ibm.cognos.cm.repositoryService.authorization.AuthorizationAdapter;
import com.ibm.cognos.cm.repositoryService.response.BaseURLResponder;
import com.ibm.cognos.cm.repositoryService.response.CachedContentResponder;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import javax.mail.internet.InternetHeaders;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.io.Charsets;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RedirectResponder
extends BaseURLResponder {
    private static Log log = LogFactory.getLog(CachedContentResponder.class);
    private String webcontentRoot;

    public RedirectResponder(String gatewayConfigURL) {
        this(gatewayConfigURL, null);
    }

    public RedirectResponder(String gatewayConfigURL, String webcontentRoot) {
        super(gatewayConfigURL);
        this.webcontentRoot = webcontentRoot == null ? "/bi" : ("/".equals(webcontentRoot) ? "" : webcontentRoot);
    }

    @Override
    public void respond(IQueryResult result, MessageContext context, AuthorizationAdapter adaptor) throws RepositoryException {
        String url = this.getPropertyValue(result.getObjects(), "redirectURI");
        boolean isExternalResource = this.getIsExternalResource(result.getObjects());
        String scriptName = this.buildScriptNameURL(context);
        StringBuffer locationURL = new StringBuffer();
        if (isExternalResource) {
            String webContent = context.getStrProperty("WEB_CONTENT_ROOT");
            if (webContent != null && !webContent.isEmpty() && !"/".equals(webContent)) {
                URI webContentRootURI = URI.create(scriptName).resolve(webContent);
                locationURL.append(webContentRootURI);
            }
            locationURL.append(this.webcontentRoot);
        } else {
            locationURL.append(scriptName);
        }
        locationURL.append(url);
        String encodedURL = this.encodeURL(context, locationURL);
        this.respondWithRedirect(context, encodedURL);
    }

    String buildScriptNameURL(MessageContext mc) {
        InternetHeaders hdrs;
        BIBusEnvelope request = (BIBusEnvelope)mc.getProperty("request.envelope");
        String serverPath = this.getValue(request, hdrs = (InternetHeaders)mc.getProperty("request.headers"), "SCRIPT_NAME", "original-script-name");
        if (serverPath == null) {
            try {
                URI uri = new URI(this.gatewayConfigURL);
                serverPath = uri.getPath();
            }
            catch (URISyntaxException e) {
                serverPath = this.gatewayConfigURL;
            }
        }
        return serverPath;
    }

    void respondWithRedirect(MessageContext context, String encodedURL) {
        ArrayList<InputStream> attachments = new ArrayList<InputStream>();
        String locationHeader = "Location: " + encodedURL;
        ByteArrayInputStream attachmentPart = new ByteArrayInputStream(locationHeader.getBytes(Charsets.US_ASCII));
        attachments.add(attachmentPart);
        this.setResponseEnvelope(context);
        this.respondAsAttachment(context, attachments, 302);
    }

    String encodeURL(MessageContext context, StringBuffer buffer) throws RepositoryException {
        HttpServletResponse response = (HttpServletResponse)context.getProperty("servlet.response");
        try {
            String encodedPath = URIUtil.encodePathQuery((String)buffer.toString(), (String)"UTF-8");
            return encodedPath;
        }
        catch (URIException e) {
            throw new RepositoryException(e.getLocalizedMessage());
        }
    }

    String getPropertyValue(IQueryResultObjects resultObjects, String propertyName) throws RepositoryException {
        String value = null;
        resultObjects.reset();
        if (resultObjects.next()) {
            value = (String)resultObjects.getPropertyValue(propertyName);
        }
        if (value == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            iae.fillInStackTrace();
            log.debug((Object)("Error sending redirect response.  No property value for property '" + propertyName + "'"), (Throwable)iae);
            throw new RepositoryException((Resource.Id)RepositoryPluginErrors.REP_API.objectNotFound, (Throwable)iae);
        }
        return value;
    }

    private boolean getIsExternalResource(IQueryResultObjects resultObjects) {
        resultObjects.reset();
        if (resultObjects.next()) {
            return (Boolean)resultObjects.getPropertyValue("isExternalResource");
        }
        return false;
    }
}

